#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(PTD2, PTD3, PTD1, PTD0, PTD5, PTD4);    // mosi, miso, sck, csn, ce, irq
DigitalOut GreenLED(PTA12);


int main() {
    
    char count[3];
    char RxDataCnt;
    char temp;
    
    float x,y,z;
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setRfFrequency(2422);

    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress() );

    pc.printf( "Simple 3 Byte Receiver\r\n" );
    
    RxDataCnt = 3;
    my_nrf24l01p.setTransferSize( RxDataCnt );
    
    my_nrf24l01p.setReceiveMode();
    my_nrf24l01p.enable();

    while (1) {

        // If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable() ) {

            // ...read the data into the receive buffer
            temp = my_nrf24l01p.read( NRF24L01P_PIPE_P0, count, RxDataCnt );
            if(count[0]>100)
                x=(count[0]-100)/(-50);
            else
                x=count[0]/50.0;
                
            if(count[1]>100)
                y=(count[1]-100)/(-50);
            else
                y=count[1]/50.0;
                
            if(count[2]>100)
                z=(count[2]-100)/(-50);
            else
                z=count[2]/50.0;
                
            pc.printf( "Cnt %d = x_axis-->%d y_axis-->%d z_axis%d\r\n",temp,x,y,z);


            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            GreenLED = !GreenLED;
            wait_ms(10);
        }
    }
}

