/*
Copyright (c) 2017 Analog Devices, Inc.

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:
  - Redistributions of source code must retain the above copyright notice,
    this list of conditions and the following disclaimer.
  - Redistributions in binary form must reproduce the above copyright notice,
    this list of conditions and the following disclaimer in the documentation
    and/or other materials provided with the distribution.
  - Modified versions of the software must be conspicuously marked as such.
  - This software is licensed solely and exclusively for use with processors
    manufactured by or for Analog Devices, Inc.
  - This software may not be combined or merged with other code in any manner
    that would cause the software to become subject to terms and conditions
    which differ from those listed here.
  - Neither the name of Analog Devices, Inc. nor the names of its
    contributors may be used to endorse or promote products derived
    from this software without specific prior written permission.
  - The use of this software may or may not infringe the patent rights of one
    or more patent holders.  This license does not release you from the
    requirement that you obtain separate licenses from these patent holders
    to use this software.

THIS SOFTWARE IS PROVIDED BY ANALOG DEVICES, INC. AND CONTRIBUTORS "AS IS" AND ANY
EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, NON-INFRINGEMENT,
TITLE, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
NO EVENT SHALL ANALOG DEVICES, INC. OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, PUNITIVE OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, DAMAGES ARISING OUT OF CLAIMS OF INTELLECTUAL
PROPERTY RIGHTS INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*!
 ******************************************************************************
 * @file:   adi_sense_config_types.h
 * @brief:  Type definitions for ADISENSE API.
 *-----------------------------------------------------------------------------
 */

#ifndef __ADI_SENSE_CONFIG_TYPES_H__
#define __ADI_SENSE_CONFIG_TYPES_H__

#include "adi_sense_platform.h"
#include "adi_sense_1000/adi_sense_1000_config.h"

/*! @addtogroup ADISENSE_Api ADISENSE Host Library API
 *  @{
 */

#ifdef __cplusplus
extern "C" {
#endif

/*! A list of supported product identifiers */
typedef enum {
    ADI_SENSE_PRODUCT_ID_ADSNS1000 = 0x0020,
    /*!< ADSNS1000 */
} ADI_SENSE_PRODUCT_ID;

/*! ADISENSE Configuration schema version */
typedef struct {
    uint8_t major; /*!< Major version number */
    uint8_t minor; /*!< Minor version number */
} ADI_SENSE_CONFIG_VERSION_ID;

/*! ADISENSE UUID string length */
#define ADI_SENSE_UUID_LEN 36

/*! ADISENSE global configuration details */
typedef struct {
    const char                  configUuid[ADI_SENSE_UUID_LEN];
    /*!< Optional unique identifier for this configuration */
    ADI_SENSE_CONFIG_VERSION_ID versionId;
    /*!< Identifies the schema version for this configuration */
    ADI_SENSE_PRODUCT_ID        productId;
    /*!< Identify the product type for which this configuration is valid */
    union
    {
        ADI_SENSE_1000_CONFIG   adisense1000;
        /*!< ADSNS1000 product configuration parameters.  Used if productId
         *   selected is ADI_SENSE_PRODUCT_ID_ADSNS1000 */
    };
    /*!< Product-specific configuration parameters, selected based on productId.
     *   @note Other product variants may be added here in the future */
} ADI_SENSE_CONFIG;

#ifdef __cplusplus
}
#endif

/*!
 * @}
 */

#endif /* __ADI_SENSE_CONFIG_TYPES_H__ */
