
/*!
 ******************************************************************************
 * @file: sensor2_bridge_6w_pressure_config
 * @brief: Initilize the sensor configuration
 *-----------------------------------------------------------------------------
 */
#include "adi_sense_config_types.h"

ADI_SENSE_CONFIG sensor2_bridge_6w_pressure_config = 
{
    .versionId = { .major = 1, .minor = 4 },
    .productId = ADI_SENSE_PRODUCT_ID_ADSNS1000,
    .adisense1000 = 
        {
        .power = 
        {
            .powerMode = ADI_SENSE_1000_POWER_MODE_FULL,
        },
        .measurement = 
        {
            .operatingMode = ADI_SENSE_1000_OPERATING_MODE_CONTINUOUS,
            .dataReadyMode = ADI_SENSE_1000_DATAREADY_PER_CYCLE,
        },
    
    /*
        Define the channels and operating mode
    */
        .channels = 
        {
            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_3] = 
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig = 
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_1_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter = 
                        {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                        },
                    .reference = 
                        {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                        },
                    .enableVbias = false,
                },
            },
            
            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_2] = 
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig = 
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_2_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter = 
                        {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                        },
                    .reference = 
                        {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                        },
                    .enableVbias = false,
                },
            },
            
            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_1] = 
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig = 
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_3_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter = 
                        {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                        },
                    .reference = 
                        {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                        },
                    .enableVbias = false,
                },
            },
            
            [ADI_SENSE_1000_CHANNEL_ID_SENSOR_0] = 
            {
                .enableChannel = true,
                .disablePublishing = false,
                .compensationChannel = ADI_SENSE_1000_CHANNEL_ID_NONE,
                .measurementsPerCycle = 1,
                .extraSettlingTime = 20000,
                .adcChannelConfig = 
                {
                    .sensor = ADI_SENSE_1000_ADC_SENSOR_BRIDGE_4WIRE_4_DEF_L2,
                    .gain = ADI_SENSE_1000_ADC_GAIN_1X,
                    .filter = 
                        {
                        .type = ADI_SENSE_1000_ADC_FILTER_FIR_25SPS,
                        },
                    .reference = 
                        {
                        .type = ADI_SENSE_1000_ADC_REFERENCE_BRIDGE_EXCITATION,
                        .disableBuffer = false,
                        },
                    .enableVbias = false,
                },
            },
            
        },
    },
};

