/*

Created on: 27/08/2018
Author: Rohan Gurav
        
Code: Use the following code to read the ADXL355 values connected to the SPI channel 
      of the EV-COG4050-Expander board port0. Check the readme.md for connection info  
      
*/
#include "mbed.h"
#include "ADXL355.h"

Serial pc(USBTX, USBRX);
int axis = 0;

ADXL355 accl(SPI1_CS0, SPI1_MOSI, SPI1_MISO, SPI1_SCLK);    // PMOD port

float single_axis(float a);
float single_axisz(float a);
float dual_axis(float a, float b);
float tri_axis(float a, float b, float c);
    
int main()
{
    pc.baud(9600);
    pc.printf("SPI ADXL355 and ADXL357 Demo\r\n");
    pc.printf("GET device ID\r\n");
   
    accl.reset();
    uint8_t d, ad, mems, device, rev; 
    
    wait(0.2);
    
    ad = accl.read_reg(accl.DEVID_AD);
    mems = accl.read_reg(accl.DEVID_MST);
    device = accl.read_reg(accl.PARTID);
    rev = accl.read_reg(accl.REVID);
    
    pc.printf("GET device data [x, y, z, t] \r\n");
    
    accl.set_power_ctl_reg(accl.MEASUREMENT);
    d=accl.read_reg(accl.POWER_CTL);
    pc.printf("power control on measurement mode = %x \r\n",d);
    
    float x,y,z,t;
    float a,b,c;
        
    double tilt_x, tilt_y, tilt_z;
    double tilt_2x, tilt_2y;
    double tilt_3x, tilt_3y, tilt_3z;
        
    //pc.printf("Enter no of axis for angle calculation (1/2/3):\r\n");
    //pc.scanf("%d",&axis);
    axis = 2;
    pc.printf("||x_accl||y_accl||z_accl||x_tilt||y_tilt||z_tilt||\r\n");
   
    wait(1);
    
    //Device ID display
        pc.printf("AD id = %x MEMS id = %x device=%x revision=%x \r\n", ad, mems, device, rev);
        
    /*The following part is used to perform 2's complemient and then display the data*/
    while (1)
    {
                    
        //*accl.axis355_sens
        x = (accl.convert(accl.scanx()));
        y = (accl.convert(accl.scany()));
        z = (accl.convert(accl.scanz()));
        t = 25+float(accl.scant()-1852)/(-9.05);
                                  
        
                                    
        if (axis==1)
        {
            char in = pc.getc();
            if(in == 'x')
                {pc.printf("%0.2f" ,x); 
                }
                
            else if(in == 'y')
                {pc.printf("%0.2f" ,y); 
                }
                
            else if(in == 'z')
                {pc.printf("%0.2f" ,z); 
                }
               
        }
        
        if (axis==2)
        {
            pc.printf("||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f|| \r\n" , x*accl.axis355_sens, y*accl.axis355_sens, z*accl.axis355_sens, tilt_x, tilt_y, tilt_z);
            wait(0.5);
        }
      
        if (axis==3)
        {
            pc.printf("||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f||%0.2f|| \r\n" ,  x, y, z, tilt_x, tilt_y, tilt_z);
            wait(1.0);
        }
        
        if (axis == 4)
        {
            pc.printf("axis|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f|%0.2f| \r\n" ,  x*accl.axis355_sens, y*accl.axis355_sens, z*accl.axis355_sens, tilt_x, tilt_y, tilt_z, tilt_2x, tilt_2y, tilt_3x, tilt_3y, tilt_3z);
            wait(1.0);
        }
        
    }

}
//the addition of accl should be equal to 1 i.e. ( x+y+z = 1 )

//single axis arcsin (0.2)
    float single_axis(float a)
    {
        a = a*accl.axis355_sens;
        
        if (a>1.0f)
        { a = 1;
        }
        else if (a<-1)
        { a = -1;
        }
        else 
        { a = a;    
        }
        
        double Y;
        
        Y = asin(a);
        Y = floor((57.2957f*Y)*100)/100;
        return Y;
                    
    }
    //particullary for z axis single
    float single_axisz(float a)
    {
        a = a*accl.axis355_sens;
        
        if (a>1.0f)
        { a = 1;
        }
        else if (a<-1)
        { a = -1;
        }
        else 
        { a = a;    
        }
        
        double Y;
        
        Y = acos(a);
        Y = floor((57.2957f*Y)*100)/100;
        return Y;
                    
    }

//Dual Axis 
    float dual_axis(float a, float b)
    {
        double Y;
        Y = 57.2957f * (atan(a/b));
        Y = floor(Y*100)/100;
        return Y;    
    }

//Triaxial
    float tri_axis(float a, float b, float c)
    {
        double Y;
        double X;
        X = (a)/(sqrt((b*b)+(c*c)));
        Y= atan(X);
        Y = floor(Y*57.2957f*100)/100;
        return Y;    
    }
