#include "mbed.h"
#include "ssd1306.h"

I2C i2c(p28, p27);

//Host PC Baudrate (Virtual Com Port on USB)
#define usbBR            115200
//#define oled_adr         0x3C
#define oled_adr         0x78
// mbed Interface Hardware definitions
DigitalOut l1(LED1);
DigitalOut l2(LED2);
DigitalOut l3(LED3);
DigitalOut l4(LED4);

// Host PC Communication channels
Serial usb(USBTX, USBRX); // tx, rx
SSD1306 oled(p28, p27,oled_adr);
//SSD1306 oled(&i2c,oled_adr);

int status1 = 0, status2 = 0;


int init(void){
    usb.baud(usbBR); wait(0.3);
   i2c.frequency(400000); wait(0.3);
    usb.printf("Bonjour ..... OLED SSD1306\r\n");

    l1= 1; l2= 0; l3= 0; l4= 0; wait(0.5);
    l1= 0; l2= 1; l3= 0; l4= 0; wait(0.5);
    l1= 0; l2= 0; l3= 1; l4= 0; wait(0.5);
    l1= 0; l2= 0; l3= 0; l4= 1; wait(0.5);
    l1= 0; l2= 0; l3= 0; l4= 0; wait(0.5);
    oled.speed(SSD1306::Medium);
    oled.init();
    oled.cls();
    oled.locate(3,1);
    oled.printf("Hello OLED !");
    oled.line(6,22,114,22,SSD1306::Normal);
    oled.line(114,22,114,33,SSD1306::Normal);
    oled.line(114,33,6,33,SSD1306::Normal);
    oled.line(6,33,6,22,SSD1306::Normal);
    oled.fill(0,0);
    oled.redraw();
    return status1;
    }

int main(void){
    status1= init();
    while(true){
        };
    return status2;
    }
