/************************************
20160605 ver1.0
どちらかのスイッチを押してゲームスタート。
カウント音の後にLEDが8回お手本で光るので、
その後光ったLEDと同じ側にあるスイッチをお手本と同じ順番通りに押す。
終わった後にまた適当なスイッチを押せば再スタート。
defineしてあるTIMESの数値を変更することで何回光るか変えられる。
スピーカーモジュールをE3ソケットに取り付けること。
************************************/

#include "mbed.h"
#include "beep_sound.h"
#include <stdlib.h>
#define TIMES 8

DigitalOut led1(A1);
DigitalOut led2(A0);
DigitalIn sw1(D4);
DigitalIn sw2(D5);
beep_sound sound(D10);

void beep(void){
    sound.onpu(2,0,0.1);
    sound.onpu(2,7,0.1);
}

int main(void) {
    int seed,
        j,  // whileループ内で使うフラグ
        states, // 0ならゲームクリア、0以外なら失敗
        randomNum;  // seed値からさらにランダムな数を作る
    int sayuu[TIMES];   // 1なら左、2なら右のLED

    while(1){
        //各種初期化
        j=0;
        states=0;
        printf("\nSTART\n\r");
        seed=0;
        while(sw1==0 && sw2==0){
            seed++;
            wait(0.001);
        }
        printf("seed=%d\n\r", seed);
        srand(seed);
        for(int i=0; i<TIMES; i++){
            // rand()の下位ビットの周期性への対策
            randomNum = (rand()%11)+(rand()%12)+(rand()%13);
            sayuu[i]=(randomNum%2)+1;
            printf("%d\n\r",(randomNum%2)+1);
        }

        /* ゲームスタート */
        sound.beep_readyGo(1);
        for(int i=0; i<TIMES; i++){
            if(sayuu[i]==1){
                led1=1;
                wait(0.1);
                led1=0;
            }else{
                led2=1;
                wait(0.1);
                led2=0;
            }
            wait(0.1);
        }
        beep();
        /* 入力開始 */
        while(j<TIMES){
            if(sayuu[j]==1 && sw1==1){
                led1=1;
                for(int i=0;i<2500;i++){while(sw1==1);}
                led1=0;
                j++;
            }else if(sayuu[j]==2 && sw2==1){
                led2=1;
                for(int i=0;i<2500;i++){while(sw2==1);}
                led2=0;
                j++;
            }else if(sayuu[j]==1 && sw2==1){
                led2=1;
                sound.beep_wrong(1);
                led2=0;
                states++;
                break;
            }else if(sayuu[j]==2 && sw1==1){
                led2=1;
                sound.beep_wrong(1);
                led2=0;
                states++;
                break;
            }
        }
        //printf("%d\n\r", states);
        // 以下パーフェクトの場合の挙動
        if(states==0){
            led1=1;
            led2=1;
            sound.beep_right(1);
            led1=0;
            led2=0;
            wait(0.1);
            led1=1;
            led2=1;
            sound.beep_right(1);
            led1=0;
            led2=0;
            wait(0.1);
            led1=1;
            led2=1;
            sound.beep_right(1);
            led1=0;
            led2=0;
            wait(0.1);
        }
        wait(0.5);

    }
}
