#include "mbed.h"
#include "stdio.h"
#include "SonicDist.h"
#include "beep_sound.h"

PwmOut R1(PA_11);
PwmOut R2(PC_6);
PwmOut L1(PC_8);
PwmOut L2(PC_9);
SonicDist sd(D9,A3);
DigitalOut ledR(A0);
DigitalOut ledB(A1);
beep_sound bs(D10);

/* 前進関数 */
void accel(double val){
    R1 = 0;
    R2 = val;
    L1 = 0;
    L2 = val;
}
/* 空転関数 */
void idling(void){
    R1 = 0;
    R2 = 0;
    L1 = 0;
    L2 = 0;
}

int main(void){
    double n, dis = sd.read();
    while(1){
        dis = sd.read();
        n = dis/30;
        if(n>=1){
            idling();
            ledR=0;
            ledB=1;
        }else{
            accel(1.0-n);
            ledR=1;
            ledB=0;
            bs.onpu(2,0,0.01);
        }
    } 
}