#include "mbed.h"

//各キー格納用
int Key_A = 0;
int Key_B = 0;
int Key_Up = 0;
int Key_Down = 0;
int Key_Left = 0;
int Key_Right = 0;

int Key_1 = 0;
int Key_2 = 0;

int Key_Home = 0;
int Key_Plus = 0;
int Key_Minus = 0;

//テスト用
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

//PWM出力用
PwmOut pwm1(p21);   
PwmOut pwm2(p22);
PwmOut pwm3(p23);
PwmOut pwm4(p24);
PwmOut pwm5(p25);
PwmOut pwm6(p26);

void setup ()// 最初の処理
{
    pwm1.period(0.010);     //PWMの周期指定 10[ms]に指定
    pwm2.period(0.010);
    pwm3.period(0.010);
    pwm4.period(0.010);
    pwm5.period(0.010);
    pwm6.period(0.010);
}

void Button(int pad){
    
    //HomeKeyの感知
    if (pad >= 0x8000){
        Key_Home = 1;
        pad -= 0x8000;
    }
    else{
        Key_Home = 0;
    }
    
    //マイナスKeyの感知
    if (pad >= 0x1000){
        Key_Minus = 1;
        pad -= 0x1000;
    }
    else{
        Key_Minus =0;
    }
    
    //AKeyの感知
    if (pad >= 0x0800){
        Key_A = 1;
        pad -= 0x0800;
    }
    else{
        Key_A =0;
    }
    
    //BKeyの感知
    if (pad >= 0x0400){
        Key_B = 1;
        pad -= 0x0400;
    }
    else{
        Key_B =0;
    }
    
    //1Keyの感知
    if (pad >= 0x0200){
        Key_1 = 1;
        pad -= 0x0200;
    }
    else{
        Key_1 =0;
    }
    
    //2Keyの感知
    if (pad >= 0x0100){
        Key_2 = 1;
        pad -= 0x0100;
    }
    else{
        Key_2 =0;
    }
    
    //PlusKeyの感知
    if (pad >= 0x0010){
        Key_Plus = 1;
        pad -= 0x0010;
    }
    else{
        Key_Plus =0;
    }
    
    //UpKeyの感知
    if (pad >= 0x0008){
        Key_Up = 1;
        pad -= 0x0008;
    }
    else{
        Key_Up =0;
    }
    
    //DownKeyの感知
    if (pad >= 0x0004){
        Key_Down = 1;
        pad -= 0x0004;
    }
    else{
        Key_Down =0;
    }
    
    //RightKeyの感知
    if (pad >= 0x0002){
        Key_Right = 1;
        pad -= 0x0002;
    }
    else{
        Key_Right =0;
    }
    
    //LeftKeyの感知
    if (pad >= 0x0001){
        Key_Left = 1;
        pad -= 0x0001;
    }
    else{
        Key_Left =0;
    }
}

 void PWM_Control(int pad,int x,int y,int z)
{
    Button(pad);
    
    if (Key_A == 1){
        pwm1 = 0.5;
        pwm4 = 0.5;
    }
    //デバッグ表示用
    //printf("A %d B %d + %d - %d U %d D %d L %d R %d 1 %d 2 %d \n",Key_A,Key_B,Key_Plus,Key_Minus,Key_Up,Key_Down,Key_Left,Key_Right,Key_1,Key_2);
    //printf("WII %04X %d %d %d\n",pad,x,y,z);
}