/*
 * BMP085 Sensor Library for mbed
 */

#ifndef BMP085_H
#define BMP085_H

#include "mbed.h"

/**
 * BMP085 Class to read temprature & pressure from BMP085(GY-65)
 *
 */
class BMP085
{
public:
    /**
     * BMP085 constructor
     * @param sda SDA pin
     * @param sdl SCL pin
     * @param addr addr of the I2C peripheral
     */
    BMP085(PinName sda, PinName scl);

    void read(int32_t * temperature, int32_t * pressure);
    void set_oversampling(int osrs);
    
    static const float p0;
    static float altitude(float p);
    

private:
    I2C m_i2c;
    char m_addr;
    
    int16_t ac1;
    int16_t ac2;
    int16_t ac3;
    uint16_t ac4;
    uint16_t ac5;
    uint16_t ac6;
    int16_t b1;
    int16_t b2;
    int16_t mb;
    int16_t mc;
    int16_t md;
    
    uint8_t oss;
    
    void writeRegs(uint8_t * data, int len);
    void readRegs(int addr, uint8_t * data, int len);
    
    void calibration(void);
    int32_t read_pressure(void);
    int32_t read_temp(void);
};
#endif

    
