#include "mbed.h"

#define sqr(x) (x)*(x)
#define abs(x)  (x)<0 ? -(x):(x)
Serial pc(PA_2,PA_3);

// sin(x)0 x- (x^3/3!)+(x^5/5!)-(x^7/7!)+ (x^9/9!)- (x^11/!)+...
float mysin(float x)

{
    float sinx=x;
    float term=x;
    int   step=2;
    int   sign=-1;
    
    do
    {
        term *= sqr(x)/(step*(step+1));
        sinx += term * sign;
        step += 2;
        sign *= -1;
    }
    while (abs (term) >0.00001F);
    
    return sinx;
}


int main() {
    
 
    float x= 0;
    
    pc.baud(115200);
    while(1)
    {   
        
        pc.printf("#A%f\r\n",10*mysin(x));
    
        x=x+0.01F;
        if (x > 6.28F) 
        x=0;
        
        wait(0.1);
    }

}