/* mbed EM-406 GPS Module Library
 * Copyright (c) 2008-2010, sford
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#include "GPS.h"

GPS::GPS(PinName tx, PinName rx) : _gps(tx, rx) {
    //_gps.baud(4800);
    longitude = 0.0;
    latitude = 0.0;
    altitude = 0.0;
    
}

int GPS::sample() {
    float time,horizontal;
    float time2,longitude2,latitude2,Speed,track;
    char  ns,ew,aut,ac,ns2,ew2;
    //int data;
    //float Hdop, Pdop;
    char Aut;
    //char star;
    //int check_data;
    //char  Pdop;
    //int   fix_3d;
    //int   Id1,Id2,Id3,Id4,Id5,Id6,Id7,Id8,Id9,Id10,Id11,Id12;

    //return 1; //testing by Jigar
    while (1) {
        getline();
        //printf("\n\rentered the GPS.sample while loop \n\r %s\n\r", msg);
        
        
        /* $GPGGA,123519,4807.038,N,01131.000,E,1,08,0.9,545.4,M,46.9,M,,*47

     Where:
     GGA          Global Positioning System Fix Data
     123519       Fix taken at 12:35:19 UTC
     4807.038,N   Latitude 48 deg 07.038' N
     01131.000,E  Longitude 11 deg 31.000' E
     1            Fix quality: 0 = invalid
                               1 = GPS fix (SPS)
                               2 = DGPS fix
                               3 = PPS fix
                   4 = Real Time Kinematic
                   5 = Float RTK
                               6 = estimated (dead reckoning) (2.3 feature)
                   7 = Manual input mode
                   8 = Simulation mode
     08           Number of satellites being tracked
     0.9          Horizontal dilution of position
     545.4,M      Altitude, Meters, above mean sea level
     46.9,M       Height of geoid (mean sea level) above WGS84
                      ellipsoid
     (empty field) time in seconds since last DGPS update
     (empty field) DGPS station ID number
     *47          the checksum data, always begins with **/
       // if (sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%*d,%*d, %*f,%*f,%*f,%*f,%*f,%*f,%d ", &time, &latitude, &ns, &longitude, &ew, &lock) >= 1) {
        if(sscanf(msg, "GPGGA,%f,%f,%c,%f,%c,%d,%d,%f,%f", &time, &latitude, &ns, &longitude, &ew, &fix,& sat_tracked,&horizontal,&altitude) >= 1) { 

            if (!fix) 
            {
                longitude = 0.0;
                latitude = 0.0;
                altitude = 0.0;
                utc=0.0;
                sat_tracked=0;
                return 0;
            } 
            else 
            {
                if (ns == 'S') {
                    latitude  *= -1.0;
                }
                if (ew == 'W') {
                    longitude *= -1.0;
                }
                float degrees = trunc(latitude / 100.0f);
                float minutes = latitude - (degrees * 100.0f);
                latitude = degrees + minutes / 60.0f;
                degrees = trunc(longitude / 100.0f ); //degrees = trunc(longitude / 100.0f * 0.01f);
                minutes = longitude - (degrees * 100.0f);
                longitude = degrees + minutes / 60.0f;
                /*int hour = time/10000;
                int min = (time % 10000)/100;
                int sek = (time % 100);*/
                utc=time;
                //sat_use=sat;
                //altitude = altitude;
                //fix=lock;
                return 1;
            }
        } 
       //getline();
       /** $GPGSA,A,3,04,05,,09,12,,,24,,,,,2.5,1.3,2.1*39

     Where:
     GSA      Satellite status
     A        Auto selection of 2D or 3D fix (M = manual) 
     3        3D fix - values include: 1 = no fix
                                       2 = 2D fix
                                       3 = 3D fix
     04,05... PRNs of satellites used for fix (space for 12) 
     2.5      PDOP (dilution of precision) 
     1.3      Horizontal dilution of precision (HDOP) 
     2.1      Vertical dilution of precision (VDOP)
     *39      the checksum data, always begins with **/
     //getline2();
       /*if(sscanf(msg, "GPGSA,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f",&fix_3d,&id1,&id2,&id3,&id4,&id5,&id6,&id7,&id8,&id9,&id10,&id11,&id12,&Pdop,&Hdop)>=1);
       {
           
            if (fix_3d==1) 
            {
                id1=id2=id3=id4=id5=id6=id7=id8=id9=id10=id11=id12=0;
                pdop=0.0;
                hdop=0.0;
                //vdop=0.0;
                
                return 0;
            } 
            else
            {
                pdop=Pdop;
                hdop=Hdop;
                //vhop=Vhop;
                //aut=Aut;
                return 1;
                
            }
       }*/
        if(sscanf(msg, "GPGSA,%c,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d", &Aut, &fix_3d,&id1,&id2,&id3,&id4,&id5,&id6,&id7,&id8,&id9,&id10,&id11,&id12,&id13) >= 1) 
       {
           
            if (fix_3d==1) 
            {
                id1=id2=id3=id4=id5=id6=id7=id8=id9=id10=id11=id12=0;
                //pdop=0.0;
                //hdop=0.0;
                //vdop=0.0;
                
                return 0;
            } 
            else
            {
                //pdop=Pdop;
                //hdop=Hdop;
                //vhop=Vhop;
                aut=Aut;
                return 1;
                
            }
       }
          if(sscanf(msg, "GPRMC,%f,%c,%f,%c,%f,%c,%f,,%d", &time2, &ac, &latitude2, &ns2, &longitude2, &ew2, &speed, &date)>=1)
        {
            //speed=Speed;
            //date=Date;
            //return 1;
        }   
        return 0;
        }
    }

       /**$GPRMC,123519,A,4807.038,N,01131.000,E,022.4,084.4,230394,003.1,W*6A
        Where:
        RMC          Recommended Minimum sentence C
        123519       Fix taken at 12:35:19 UTC
        A            Status A=active or V=Void.
        4807.038,N   Latitude 48 deg 07.038' N
        01131.000,E  Longitude 11 deg 31.000' E
        022.4        Speed over the ground in knots
        084.4        Track angle in degrees True
        230394       Date - 23rd of March 1994
        003.1,W      Magnetic Variation
        *6A          The checksum data, always begins with **/  
     
        
        //return 0;


float GPS::trunc(float v) {
    if (v < 0.0) {
        v*= -1.0;
        v = floor(v);
        v*=-1.0;
    } else {
        v = floor(v);
    }
    return v;
}

void GPS::getline() {
    char c;
    while (c = _gps.getc() != '$');   // wait for the start of a line
    // printf("entered the getline loop\n\r");
    for (int i=0; i<280; i++) {
        msg[i] = _gps.getc();
        if (msg[i] == '\r') {
            msg[i] = 0;
            return;
        }
    }
    error("Overflowed message limit");
}
/*void GPS::getline2() {
    char c;
    while (c = _gps.getc() != '$');   // wait for the start of a line
    // printf("entered the getline loop\n\r");
    for (int i=0; i<300; i++) {
        msg2[i] = _gps.getc();
        if (msg2[i] == '\r') {
            msg2[i] = 0;
            return;
        }
    }
    error("Overflowed message limit");
}*/

/*
$GPRMC,000115.039,V,,,,,,,291006,,*2C
$GPGGA,000116.031,,,,,0,00,,,M,0.0,M,,0000*52
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPGSV,3,1,12,20,00,000,,10,00,000,,31,00,000,,27,00,000,*7C
$GPGSV,3,2,12,19,00,000,,07,00,000,,04,00,000,,24,00,000,*76
$GPGSV,3,3,12,16,00,000,,28,00,000,,26,00,000,,29,00,000,*78
$GPRMC,000116.031,V,,,,,,,291006,,*27
$GPGGA,000117.035,,,,,0,00,,,M,0.0,M,,0000*57
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPRMC,000117.035,V,,,,,,,291006,,*22
$GPGGA,000118.039,,,,,0,00,,,M,0.0,M,,0000*54
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPRMC,000118.039,V,,,,,,,291006,,*21
$GPGGA,000119.035,,,,,0,00,,,M,0.0,M,,0000*59
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPRMC,000119.035,V,,,,,,,291006,,*2C
$GPGGA,000120.037,,,,,0,00,,,M,0.0,M,,0000*51
$GPGSA,A,1,,,,,,,,,,,,,,,*1E
$GPRMC,000120.037,V,,,,,,,291006,,*24

*/