#include "mbed.h"
#include "GPS.h"
#include "MODSERIAL.h"
#include <iostream>
#include <sstream>
#include <bitset>
#include <string>
#include "FATFileSystem.h"
#include "SDBlockDevice.h"
#include <stdio.h>
#include <errno.h>
#include <stdio.h>


SDBlockDevice bd(D11, D12, D13, D10);
Serial pc(PA_2,PA_3);
Serial SIM900(PA_9,PA_10);                // (TX,RX)    
//MODSERIAL pc(PA_2,PA_3);
//MODSERIAL SIM900(PA_9,PA_10);
GPS gps (PA_11,PA_12);

const string GoogleChunk  = "https://maps.google.com.au/maps?q=";   // URL constant
const string GoogleExtras = "&z=20";                                // Zoom Level
char  GPRSbuffer[200];
char resp[6]; 
char  NUMBER[14];
char str1[20];
char str2[20];
char str3[25];
char str4[25];
char passwort[100];
string MESSAGE;
bool smsRequest = false; 
int index;
int i=0;
Timer timeCnt;

#define DEFAULT_TIMEOUT         5

FATFileSystem fs("fs");
string result;
char x;

void return_error(int ret_val){
  if (ret_val)
    printf("Failure. %d\r\n", ret_val);
  else
    printf("done.\r\n");
}
 
void errno_error(void* ret_val){
  if (ret_val == NULL)
    printf(" Failure. %d \r\n", errno);
  else
    printf(" done.\r\n");
}

void clearString()
 {
  result.clear();
  }
 
void callback_rx() {
 
    while (SIM900.readable()) {
      x = SIM900.getc();
      result += x;
      pc.putc(x); // print the answer from SIM900
 
       }
}
void getlineGSM()
{
    //char c;
  timeCnt.start();  // start timer
    while(1) {
        while (SIM900.readable()) {
            char c = SIM900.getc();
            if (c == '\r' || c == '\n') c = '$';
            GPRSbuffer[i++] = c;
            if(i > 512)break;
        }
        if(i > 512)break;
        if(timeCnt.read() > DEFAULT_TIMEOUT) {
            timeCnt.stop();
            timeCnt.reset();
            break;
        }
    }
    wait(0.5);
    while(SIM900.readable()) {  // display the other thing..
        char c = SIM900.getc();
    }
}

int readBuffer(char *buffer,int count)
{
    int i = 0;
    timeCnt.start();  // start timer
    while(1) {
        while (SIM900.readable()) {
            char c = SIM900.getc();
            if (c == '\r' || c == '\n') c = '$';
            buffer[i++] = c;
            if(i > count)break;
        }
        if(i > count)break;
        if(timeCnt.read() > DEFAULT_TIMEOUT) {
            timeCnt.stop();
            timeCnt.reset();
            break;
        }
    }
    wait(0.5);
    while(SIM900.readable()) {  // display the other thing..
        char c = SIM900.getc();
    }
    return 0;
}
void cleanBuffer(char *buffer, int count)
{
    for(int i=0; i < count; i++) {
        buffer[i] = '\0';
    }
}
void readSMS()
{
       // If theres a char waiting in the MODSERIAL buffer
        /*while (SIM900.readable()) {
        // Assign it to 'c'
        char c = SIM900.getc();
        // Replace all returns and or line endings with money!
         if (c == '\r' || c == '\n') c = '$';
        // Put it in the array
        GPRSbuffer[i] = c;
        // Repeat if possible
        i++;
    }*/
    
       if (SIM900.readable()) {
            readBuffer(GPRSbuffer,110);
            pc.printf("%s\r\n",GPRSbuffer);
            for(i=0;i<5;i++)
            {
            resp[i]=GPRSbuffer[i];
            }
        }
    //Uncomment the following to debug
            //pc.printf("\nbuffer = %s", GPRSbuffer);
           
            printf("read SMS\r\n");
            //SIM900.attach(&callback_rx);
            SIM900.attach(&callback_rx, Serial::RxIrq);
            SIM900.baud(9600);
            clearString();
            SIM900.printf("AT+CMGF=1\r"); //at command for send sms
            wait_ms(1000);
            clearString();
            wait_ms(1000);
            SIM900.printf("AT+CMGL=");
            SIM900.putc('"');
            SIM900.printf("ALL");
            SIM900.putc('"');
            SIM900.printf("\r");
            printf("\n");
            //SIM900.printf("AT+CMGR=1\r\n");
            wait_ms(1000);
            //SIM900.printf("AT+CMGD=2");
            /*SIM900.putc('"');
            SIM900.printf("DEL ALL");
            SIM900.putc('"');
            SIM900.printf("\r");
            printf("\n");*/
            //SIM900.printf("AT+CMGR=1\r\n");
            wait_ms(1000);
            //clearString();
            //cleanBuffer(GPRSbuffer,200);
            readBuffer(GPRSbuffer,200);
            readBuffer(GPRSbuffer,200);
            getlineGSM();
            wait_ms(1000);
            printf("Buffer: %s\r\n",GPRSbuffer);
            wait_ms(1000);
            if (sscanf(GPRSbuffer,"+CMTI: \"SM\",%d", &index)>0)
            {
                pc.printf("Index: %d\r\n", index);
            }
            if(sscanf(GPRSbuffer,"+CMGL: 1\"%*[^\"]\",\"%[^\"]",str3)>0)
    //"+CMGL: %d,\"%*[^\"]\",\"%[^\"]"
    //if(sscanf(GPRSbuffer,"+CMTI: \"SM \",%d",&index)>0)
    //{
    //    SIM900.printf("AT+CMGR=%d\r\n",index);
    //}
    //if(sscanf(GPRSbuffer,"+CMGR: \"%[^\"]\",\"%[^\"]\",,\"%[^\"]\"\r\n%s\r\n", str1, str2, str3, passwort)>0)
    {
        //if(passwort == "Position")
        //{
        //    smsRequest = true;
        //}
        printf("Phone number is %s\n",str3);
    }
    wait_ms(1000);
    //SIM900.printf("AT+CMGD=1\r");
    //printf("Delete SMS\r\n");
    wait_ms(1000);
}

void sendSMS()
{
   
        printf("send SMS\r\n");
        SIM900.attach(&callback_rx, Serial::RxIrq);
        SIM900.baud(9600);
        clearString();
        SIM900.printf("AT+CMGF=1\r"); //at command for send sms
        wait_ms(1000);
        clearString();
        wait_ms(1000);
        SIM900.printf("AT+CMGS=");
        SIM900.putc('"');
        SIM900.printf("+4917645651571");
        SIM900.putc('"');
        SIM900.printf("\r");
        wait_ms(1000);
        //SIM900.printf("Latitude: %0.6f, Longitude: %0.6f,Altitude: %0.3f",gps.latitude,gps.longitude,gps.altitude);
        SIM900.printf("Find me at....\n %s%f,%f%s", GoogleChunk, gps.latitude, gps.longitude, GoogleExtras);
        wait_ms(1000);
        SIM900.putc(0x1A);
        wait_ms(60000);
        //smsRequest=false;
    
}

void parseSMS()
{
    while(SIM900.readable())
    {
        // Assign it to 'c'
        char c = SIM900.getc();
        // Replace all returns and or line endings with money
        if(c == '\r' || c == '\n') c= '$';
        // Put it in the array
        GPRSbuffer[i] =c;
        // Repeat if possible
        i++;
        
    }
    // Uncomment the following to debug
     
    
    // If we get an SMS notification
    if (sscanf(GPRSbuffer,"+CMTI: \"SM\",%d", &index)>0)
    {
        pc.printf("\nSMS recieved @ index [%d]", index);
        pc.printf("\nbuffer = %s", GPRSbuffer);
        //memset(GPRSbuffer, '0', 511);
        i=0;
        pc.printf("\nOpening message...");
        // ask GPRS to read the message
        SIM900.printf("AT+CMGR=%d\r\n", index);
    }
    if (strncmp(GPRSbuffer, "+CMGR",7) == 0 ) // compared return value = 0 then it indicates str1 is equal to str2 
    {
        // Get the number out
        char *n = strstr(GPRSbuffer,"+49");     // finds the first occurrence of the substring "+49" in the string GPRSbuffer +4917645651571 
        strncpy(NUMBER, n, 14);                 // this funtion returns the final copy of the copied string
        char * pch;             
        pch = strtok (GPRSbuffer, "$$");        // return a pointer to the first token found in the string. A null pointer is returned if there are no tokens left to retrieve
        pch = strtok (NULL, "$$");
        MESSAGE = pch;
        pc.printf("\nDone! ");
        // Send the location
        //sendSMS();
        // Reset the GPRS buffer
         // memset(GPRSbuffer, '0', 511);
        // Reset the char counter
        i = 0;
        pc.printf("\nbuffer = %s", GPRSbuffer);    
    }
     if (strncmp(GPRSbuffer, "$$+CMGS",7) == 0) {
        // Reset the GPRS buffer
        //memset(GPRSbuffer, '0', 511);
        // Reset the char counter
        i = 0;
    }
    if (strncmp(GPRSbuffer, "$$RING",6) == 0) {
        SIM900.printf("ATH0\r\n");
        pc.printf("\nCall bounced!...");
        // Do the send SMS routine...
        //sendSMS();
        // Reset the GPRS buffer
        //memset(GPRSbuffer, '0', 511);
        // Reset the char counter
        i = 0;
    }
    //pc.printf("\nbuffer = %s", GPRSbuffer);
    pc.printf("\n\n\nWaiting for SMS or call...\n");
    pc.printf("\nThe last number was : %s", NUMBER);
    pc.printf("\nThe last message was : %s", MESSAGE);
    // Reset the GPRS buffer
    //memset(GPRSbuffer, '0', 511);
    // Reset the char counter
    i = 0;
}
 
int main() {
  /**/     
  /*memset(GPRSbuffer, '0', 511);
  pc.printf("\r\n GSM 900 Test\n");
  //SIM900.attach(&callback_rx);
  SIM900.baud(9600);
  wait_ms(100);
  SIM900.printf("ATE0\r\n");
  pc.printf("\nGPRS echo [OFF]\n");
    wait(1);
    // Delete all messages on the sim card
  SIM900.printf("AT+CMGDA=\"DEL ALL\"\r\n");
    wait(1);
    pc.printf("\nMessages Cleared...\n");
    wait(1);*/
  //sendSMS();
    //printf("read SMS\r\n");
    /*SIM900.printf("AT+CMGF=1\r"); //at command for send sms
    wait_ms(1000);
    SIM900.printf("AT+CMGL=\"ALL\"\r\n");
  
    wait_ms(1000);
    wait_ms(100);*/
    /*printf("read SMS\r\n");
            SIM900.attach(&callback_rx, Serial::RxIrq);
            SIM900.baud(9600);
            clearString();
            SIM900.printf("AT+CMGF=1\r"); //at command for send sms
            wait_ms(1000);
            clearString();
            wait_ms(1000);
            SIM900.printf("AT+CMGL=");
            SIM900.putc('"');
            SIM900.printf("ALL");
            SIM900.putc('"');
            SIM900.printf("\r");
            printf("\n");
            wait_ms(30000);
            if (sscanf(GPRSbuffer,"+CMTI: \"SM\",%d", &index)>0)
            {
                pc.printf("Index: %d\r\n", index);
            }*/
            //if(sscanf(GPRSbuffer,"+CMGR: 2,\"REC READ\",\"+4917645651571\",,\"2019/04/26,15:57:07+02\"\r\n%s\r\n",passwort)>0)
            
                //pc.printf("passwort: %s\r\n",passwort);
            
    //sendSMS();
    
        readSMS();
        //parseSMS();
     
 
  /**/
  int error = 0;
  printf("Welcome to the filesystem example.\r\n"
         "Formatting a FAT, RAM-backed filesystem. ");
  error = FATFileSystem::format(&bd);
  return_error(error);
 
  printf("Mounting the filesystem on \"/fs\". ");
  error = fs.mount(&bd);
  return_error(error);
 
  printf("Opening a new file, numbers.txt.");
  FILE* fd = fopen("/fs/numbers.txt", "a+");
  errno_error(fd);
  fprintf(fd,"Latitude, Longitude,Altitude,Speed in knots, Date, Time,Number of satellites being tracked, IDs of satellites ins use, Fix, Fix mode\r\n");
  printf("Closing file.");
  fclose(fd);
  printf(" done.\r\n");
 
  printf("Re-opening file read-only.");
  fd = fopen("/fs/numbers.txt", "r");
  errno_error(fd);
 
  printf("Dumping file to screen.\r\n");
  char buff[16] = {0};
  while (!feof(fd)){
    int size = fread(&buff[0], 1, 15, fd);
    fwrite(&buff[0], 1, size, stdout);
  }
  printf("EOF.\r\n");
 
  printf("Closing file.");
  fclose(fd);
  printf(" done.\r\n");
 
  printf("Opening root directory.");
  DIR* dir = opendir("/fs/");
  errno_error(fd);
 
  struct dirent* de;
  printf("Printing all filenames:\r\n");
  while((de = readdir(dir)) != NULL){
    printf("  %s\r\n", &(de->d_name)[0]);
  }
 
  printf("Closing root directory. ");
  error = closedir(dir);
  return_error(error);
  printf("Filesystem Demo complete.\r\n");
  wait(2);
  while (true) {
    pc.printf("\n");
     wait(1); 
          if(gps.sample()){
          float latitude    = gps.latitude;
          float longitude   = gps.longitude;
          float altitude    = gps.altitude;
          float utc = gps.utc+20000;
          int sat_tracked=gps. sat_tracked;
          int fix=gps.fix;
          int fix_3d=gps.fix_3d;
          int id1=gps.id1;
          int id2=gps.id2;
          int id3=gps.id3;
          int id4=gps.id4;
          int id5=gps.id5;
          int id6=gps.id6;
          int id7=gps.id7;
          int id8=gps.id8;
          int id9=gps.id9;
          int id10=gps.id10;
          int id11=gps.id11;
          int id12=gps.id12;
          float speed=gps.speed;
          int   date=gps.date;
          
          /*pc.printf("Latitude: %0.6f\r\n",latitude);
          pc.printf("Longitude:%0.6f\r\n",longitude);
          pc.printf("Altitude: %0.3f\r\n",altitude);
          pc.printf("Speed in knots: %0.2f\r\n",speed);
          pc.printf("Date: %d\r\n",date);
          pc.printf("Time UTC: %0.0f\r\n",utc);
          pc.printf("Number of satellites being tracked: %d\r\n", sat_tracked);
          pc.printf("PRNs of satellites used for fix:\r\n");
          pc.printf("ID1:%d,ID2:%d,ID3:%d,ID4:%d,ID5:%d,ID6:%d\r\n",id1,id2,id3,id4,id5,id6);
          pc.printf("ID7:%d,ID8:%d,ID9:%d,ID10:%d,ID11:%d,ID12:%d\r\n",id7,id8,id9,id10,id11,id12);
          pc.printf("Fix quality: %d - value include 0=invalid; 1=GPS fix\r\n",fix);
          pc.printf("3D fix: %d - value include: 1 = no fix, 2 = 2D fix, 3 = 3D fix\r\n\n", fix_3d); 
          pc.printf("****************************************************************\r\n");*/
          
          
          FILE* fd = fopen("/fs/numbers.txt", "a+");
          //errno_error(fd);
         if(fd != NULL)
         {
              printf("write file.\r\n");
              fprintf(fd,"%0.6f,%0.6f,%0.3f,%0.2f,%d,%0.0f,%d,%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d;%d,%d,%d\r\n",latitude, longitude, altitude, speed, date, utc, sat_tracked, id1,id2,id3,id4,id5,id6,id7,id8,id9,id10,id11,id12, fix,fix_3d);
              //fclose(fd);
              printf("Closing file.\r\n");
              fclose(fd);
              printf(" done.\r\n");
         }
 
              //printf("Re-opening file read-only.");
              //fd = fopen("/fs/numbers.txt", "r");
             //errno_error(fd);
          
          wait(1);
               //parseSMS();
               //readSMS();
          //printf("Passwort: %s\r\n",passwort);
            
            
         wait_ms(3000);
          wait(1);
          
          //sendSMS();
          
          wait(1);
      }
    }
}