#ifndef L298_H
#define L298_H

#include <mbed.h>

//RobotControl is used to control the direction and speed of the robot
//attributes : the pinouts of the enable and pwm forward and backwards
//methods : SetSpeed and SetDirection to set speed and set direction

class L298
{
private:
    
    DigitalOut m_motorBw;
    DigitalOut m_motorFw;
    PwmOut m_motorEnable;
    
    
    bool m_prevDir;
    
    
public:
    
    bool m_dir;
    float m_speed;
    
    L298(PinName pin1, PinName pin2, PinName pin3); //initializes the pins, direction and speed
    
    void SetDirection(bool dir);        //sets direction of robot, forward or backwards
    void SetSpeed(float speed);         //sets speed of robot regardless of direction
    
};




#endif