#ifndef qp_config_h
#define qp_config_h

// enable the Q-SPY software tracing instrumentation
#define Q_SPY

// enable preemptive QK kernel (cooperative kernel is used when not defined)
#define QK_PREEMPTIVE

// The maximum number of active objects in the application (could be up to 63)
#define QF_MAX_ACTIVE         16

// Uncomment the following macros only if you want to change the given default 
#define Q_SIGNAL_SIZE         1
//#define QF_EVENT_SIZ_SIZE     2
//#define QF_EQUEUE_CTR_SIZE    1
//#define QF_MPOOL_SIZ_SIZE     2
//#define QF_MPOOL_CTR_SIZE     2
//#define QF_TIMEEVT_CTR_SIZE   2 

#if (Q_SIGNAL_SIZE == 1)
    #define DEV_DRIVER_SIG  (0xFF - 8)
#elif (Q_SIGNAL_SIZE == 2)
    #define DEV_DRIVER_SIG  (0xFFFF - 8)
#elif (Q_SIGNAL_SIZE == 4)
    #define DEV_DRIVER_SIG  (0xFFFFFFFF - 8)
#else
    #error "Q_SIGNAL_SIZE not defined or incorrect"
#endif

#endif                                                          // qp_config_h