//////////////////////////////////////////////////////////////////////////////
// Model: dpp.qm
// File:  ././philo.cpp
//
// This file has been generated automatically by QP Modeler (QM).
// DO NOT EDIT THIS FILE MANUALLY.
//
// Please visit www.state-machine.com/qm for more information.
//////////////////////////////////////////////////////////////////////////////
#include "qp_port.h"
#include "dpp.h"
#include "bsp.h"

namespace DPP {

Q_DEFINE_THIS_FILE

// Active object class -------------------------------------------------------
// @(/2/0) ...................................................................
class Philo : public QP::QActive {
private:
    QP::QTimeEvt m_timeEvt;

public:
    Philo();

protected:
    static QP::QState initial(Philo * const me, QP::QEvt const * const e);
    static QP::QState thinking(Philo * const me, QP::QEvt const * const e);
    static QP::QState hungry(Philo * const me, QP::QEvt const * const e);
    static QP::QState eating(Philo * const me, QP::QEvt const * const e);
};

// Local objects -------------------------------------------------------------
static Philo l_philo[N_PHILO];   // storage for all Philos

// helper function to provide a randomized think time for Philos
inline QP::QTimeEvtCtr think_time() {
    return static_cast<QP::QTimeEvtCtr>((BSP_random() % BSP_TICKS_PER_SEC)
                                        + (BSP_TICKS_PER_SEC/2U));
}

// helper function to provide a randomized eat time for Philos
inline QP::QTimeEvtCtr eat_time() {
    return static_cast<QP::QTimeEvtCtr>((BSP_random() % BSP_TICKS_PER_SEC)
                                        + BSP_TICKS_PER_SEC);
}

// helper function to provide the ID of Philo "me"
inline uint8_t PHILO_ID(Philo const * const me) {
    return static_cast<uint8_t>(me - l_philo);
}

enum InternalSignals {           // internal signals
    TIMEOUT_SIG = MAX_SIG
};

// Global objects ------------------------------------------------------------
QP::QActive * const AO_Philo[N_PHILO] = { // "opaque" pointers to Philo AO
    &l_philo[0],
    &l_philo[1],
    &l_philo[2],
    &l_philo[3],
    &l_philo[4]
};

// Philo definition ----------------------------------------------------------
// @(/2/0) ...................................................................
// @(/2/0/1) .................................................................
Philo::Philo() 
  : QActive(Q_STATE_CAST(&Philo::initial)),
    m_timeEvt(TIMEOUT_SIG)
{
}

// @(/2/0/2) .................................................................
// @(/2/0/2/0)
QP::QState Philo::initial(Philo * const me, QP::QEvt const * const e) {
    static bool registered = false; // starts off with 0, per C-standard
    (void)e; // suppress the compiler warning about unused parameter
    if (!registered) {
        registered = true;

        QS_OBJ_DICTIONARY(&l_philo[0]);
        QS_OBJ_DICTIONARY(&l_philo[0].m_timeEvt);
        QS_OBJ_DICTIONARY(&l_philo[1]);
        QS_OBJ_DICTIONARY(&l_philo[1].m_timeEvt);
        QS_OBJ_DICTIONARY(&l_philo[2]);
        QS_OBJ_DICTIONARY(&l_philo[2].m_timeEvt);
        QS_OBJ_DICTIONARY(&l_philo[3]);
        QS_OBJ_DICTIONARY(&l_philo[3].m_timeEvt);
        QS_OBJ_DICTIONARY(&l_philo[4]);
        QS_OBJ_DICTIONARY(&l_philo[4].m_timeEvt);

        QS_FUN_DICTIONARY(&Philo::initial);
        QS_FUN_DICTIONARY(&Philo::thinking);
        QS_FUN_DICTIONARY(&Philo::hungry);
        QS_FUN_DICTIONARY(&Philo::eating);
    }
    QS_SIG_DICTIONARY(HUNGRY_SIG, me);  // signal for each Philos
    QS_SIG_DICTIONARY(TIMEOUT_SIG, me); // signal for each Philos

    me->subscribe(EAT_SIG);
    return Q_TRAN(&Philo::thinking);
}
// @(/2/0/2/1) ...............................................................
QP::QState Philo::thinking(Philo * const me, QP::QEvt const * const e) {
    QP::QState status;
    switch (e->sig) {
        // @(/2/0/2/1)
        case Q_ENTRY_SIG: {
            me->m_timeEvt.postIn(me, think_time());
            status = Q_HANDLED();
            break;
        }
        // @(/2/0/2/1)
        case Q_EXIT_SIG: {
            (void)me->m_timeEvt.disarm();
            status = Q_HANDLED();
            break;
        }
        // @(/2/0/2/1/0)
        case TIMEOUT_SIG: {
            status = Q_TRAN(&Philo::hungry);
            break;
        }
        // @(/2/0/2/1/1)
        case EAT_SIG: // intentionally fall through
        case DONE_SIG: {
            /* EAT or DONE must be for other Philos than this one */
            Q_ASSERT(Q_EVT_CAST(TableEvt)->philoNum != PHILO_ID(me));
            status = Q_HANDLED();
            break;
        }
        default: {
            status = Q_SUPER(&QHsm::top);
            break;
        }
    }
    return status;
}
// @(/2/0/2/2) ...............................................................
QP::QState Philo::hungry(Philo * const me, QP::QEvt const * const e) {
    QP::QState status;
    switch (e->sig) {
        // @(/2/0/2/2)
        case Q_ENTRY_SIG: {
            TableEvt *pe = Q_NEW(TableEvt, HUNGRY_SIG);
            pe->philoNum = PHILO_ID(me);
            AO_Table->POST(pe, me);
            status = Q_HANDLED();
            break;
        }
        // @(/2/0/2/2/0)
        case EAT_SIG: {
            // @(/2/0/2/2/0/0)
            if (Q_EVT_CAST(TableEvt)->philoNum == PHILO_ID(me)) {
                status = Q_TRAN(&Philo::eating);
            }
            else {
                status = Q_UNHANDLED();
            }
            break;
        }
        // @(/2/0/2/2/1)
        case DONE_SIG: {
            /* DONE must be for other Philos than this one */
            Q_ASSERT(Q_EVT_CAST(TableEvt)->philoNum != PHILO_ID(me));
            status = Q_HANDLED();
            break;
        }
        default: {
            status = Q_SUPER(&QHsm::top);
            break;
        }
    }
    return status;
}
// @(/2/0/2/3) ...............................................................
QP::QState Philo::eating(Philo * const me, QP::QEvt const * const e) {
    QP::QState status;
    switch (e->sig) {
        // @(/2/0/2/3)
        case Q_ENTRY_SIG: {
            me->m_timeEvt.postIn(me, eat_time());
            status = Q_HANDLED();
            break;
        }
        // @(/2/0/2/3)
        case Q_EXIT_SIG: {
            TableEvt *pe = Q_NEW(TableEvt, DONE_SIG);
            pe->philoNum = PHILO_ID(me);
            QP::QF::PUBLISH(pe, me);
            (void)me->m_timeEvt.disarm();
            status = Q_HANDLED();
            break;
        }
        // @(/2/0/2/3/0)
        case TIMEOUT_SIG: {
            status = Q_TRAN(&Philo::thinking);
            break;
        }
        // @(/2/0/2/3/1)
        case EAT_SIG: // intentionally fall through
        case DONE_SIG: {
            /* EAT or DONE must be for other Philos than this one */
            Q_ASSERT(Q_EVT_CAST(TableEvt)->philoNum != PHILO_ID(me));
            status = Q_HANDLED();
            break;
        }
        default: {
            status = Q_SUPER(&QHsm::top);
            break;
        }
    }
    return status;
}


}                                                             // namespace DPP
