#include <string>
#include "mbed.h"
#include "easy-connect.h"
#include "TCPSocket.h"
#include "DHT.h"

#define SERVER_IP   "192.168.0.9"
#define SERVER_PORT 50000

Serial pc(USBTX, USBRX);    // computer to mbed boardSerial esp(D1, D0);
DHT sensor(D7,DHT22);

void task_DHT();

void http_demo(NetworkInterface *net)
{
    int error = 0;
    int h, c, f;
    float dp = 0.0f;
    
    TCPSocket socket;       // for TCP

    pc.printf("Sending TCP request to %s:%d ...\r\n", SERVER_IP, SERVER_PORT);

    // Open a socket on the network interface, and create a TCP connection
    socket.open(net);
    socket.connect(SERVER_IP, SERVER_PORT);
    
    int scount;

    while(1){
        
        char buf[64];
        int len = socket.recv(buf, 64);
        buf[len] = '\0';
        
        char buffer[64] = "GET /DHT22";
        int result = strcmp(buf, buffer);
        printf("received: %s %d\r\n",buf,result);
        
        if (strcmp(buf, buffer)){
            printf("*****The wrong request come.*****\r\n");
            char sbuffer4[] =  "GET /Unknown request\r\n";
            //char sbuffer4[] = "{\"method\":\"GET\",\"content\":\"Unknown request\"}\r\n";
            scount = socket.send(sbuffer4, sizeof sbuffer4);
            pc.printf("send error message: %d [%.*s]\r\n", scount, strstr(sbuffer4, "\r\n")-sbuffer4, sbuffer4); 
            
        }else{ // strcmp(buf, buffer)값이 0일 때, 즉, 전송된 값이 "GET /DHT22\r\n" 일 때  
            
            printf("*****The correct request come.*****\r\n");
            char sbuffer1[] =  "GET /Ok\r\n";
            //char sbuffer1[] = "{\"method\":\"GET\",\"message\":\"Ok\"}\r\n";
            scount = socket.send(sbuffer1, sizeof sbuffer1);
            pc.printf("send Ok message: %d [%.*s]\r\n", scount, strstr(sbuffer1, "\r\n")-sbuffer1, sbuffer1);  

            error = sensor.readData();
            if (0 == error) {
                c   = sensor.ReadTemperature(CELCIUS);
                f   = sensor.ReadTemperature(FARENHEIT);
                h   = sensor.ReadHumidity();
                dp  = sensor.CalcdewPoint(c, h); 
                
                char sbuffer2[33];
                sprintf(sbuffer2, "{\"type\":\"temperature\",\"value\":%d}\r\n", c);
                scount = socket.send(sbuffer2, sizeof sbuffer2);
                pc.printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer2, "\r\n")-sbuffer2, sbuffer2);  
                
                printf("Temperature in Celcius: %d, Farenheit %d\r\n", c, f);
                 
                char sbuffer3[32];
                sprintf(sbuffer3, "{\"type\":\"humidity\",\"value\":%d}\r\n", h);
                scount = socket.send(sbuffer3, sizeof sbuffer3);
                pc.printf("sent %d [%.*s]\r\n", scount, strstr(sbuffer3, "\r\n")-sbuffer3, sbuffer3);
                
                printf("Humidity is %d, Dewpoint: %4.2f\r\n\r\n", h, dp);

            } else { // checksum error가 발생하는 경우 터미널에 error 발생을 표시            
                printf("Checksum Error: %d\r\n", error);
            }   
        }
    }    
    // Close the socket to return its memory and bring down the network interface
    socket.close();
}
/*
void task_DHT(){
        
    int error = 0;
    int h, c, f;
    float dp = 0.0f;
    char buf[256];
    
        wait(3);
        error = sensor.readData();
        if (0 == error) {
            c   = sensor.ReadTemperature(CELCIUS);
            f   = sensor.ReadTemperature(FARENHEIT);
            h   = sensor.ReadHumidity();
            dp  = sensor.CalcdewPoint(c, h);
            sprintf(buf, "Temperature in Celcius: %d, Farenheit %d\r\n", c, f);
            //printf("Temperature in Celcius: %d, Farenheit %d\r\n", c, f);
            sprintf(buf, "Humidity is %d, Dewpoint: %4.2f\r\n\n", h, dp);
            //printf("Humidity is %d, Dewpoint: %4.2f\r\n\n", h, dp);
            
        } else {            
            printf("Error: %d\r\n", error);
        }
}
*/
int main() {
    
    pc.baud(115200);
    pc.printf("\r\n Simple TCP example over ESP8266\r\n\r\n");

    pc.printf("\r\nConnecting...\r\n");
    
    NetworkInterface *network = easy_connect(true);
    
    if (!network) {
        pc.printf("Error: Cannot connect to the network\r\n");
        return -1;
    }
    
    pc.printf("Success\r\n\r\n");
    pc.printf("MAC: %s\r\n", network->get_mac_address());
    pc.printf("IP: %s\r\n", network->get_ip_address());
    pc.printf("Netmask: %s\r\n", network->get_netmask());
    pc.printf("Gateway: %s\r\n", network->get_gateway());
    pc.printf("RSSI: %d\r\n\r\n", wifi.get_rssi());

    http_demo(network);
    //network->disconnect();
    //pc.printf("\r\nDone\r\n");
    
    while(1) {
        //task_DHT();
    }
}
