#include "mbed.h"
#include "BLEDevice.h"
#include "nrf_temp.h"

BLEDevice ble;

#define NEED_CONSOLE_OUTPUT 1 /* Set this if you need debug messages on the console;
* it will have an impact on code-size and power consumption. */

#if NEED_CONSOLE_OUTPUT
Serial  pc(USBTX, USBRX);
DigitalOut led1(LED1);
#define DEBUG(...) { pc.printf(__VA_ARGS__); }
#else
#define DEBUG(...) /* nothing */
#endif /* #if NEED_CONSOLE_OUTPUT */

uint8_t beaconPayload[] = {
    0x4C, 0x00,
    0x02,
    0x15,
    0x01, 0x12, 0x23, 0x34, 0x45, 0x56, 0x67, 0x78,
    0x89, 0x9a, 0xab, 0xbc, 0xcd, 0xde, 0xef, 0xf0,
    0x00, 0x00,
    0x00, 0x00,
    0xC7
};

uint8_t counter = 100;
static volatile bool  triggerPayloadUpdatePolling = false;

void periodicCallback(void)
{
    led1 = !led1; 
    /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
     * heavy-weight sensor polling from the main thread. */
    triggerPayloadUpdatePolling = true;
}

int main(void)
{


    Ticker ticker;
    ticker.attach(periodicCallback, 1);    //Sets update time of sensors

    DEBUG("Initialising BTLE transport\n\r");
    beaconPayload[21] = 0x01;   //Minor value 2
    beaconPayload[23] = 0x01;   //Minor value 2
    ble.init();
     nrf_temp_init();
   // pc.printf("temperature init");

    ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, beaconPayload, sizeof(beaconPayload));
    ble.setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
    ble.setAdvertisingInterval(1600); /* 1s; in multiples of 0.625ms. */
    ble.startAdvertising();

    for (;;) {

        /* Note that the periodicCallback() executes in interrupt context, so it is safer to do
        * heavy-weight sensor polling from the main thread. */
        if(triggerPayloadUpdatePolling) {
            triggerPayloadUpdatePolling = false;
            if(counter<100) {
                counter++;
            } else {
                counter = 0;
            }


            int32_t temperature = 0;

            NRF_TEMP->TASKS_START = 1; /* Start the temperature measurement */
            while ((NRF_TEMP->EVENTS_DATARDY & TEMP_INTENSET_DATARDY_Msk) != (TEMP_INTENSET_DATARDY_Set << TEMP_INTENSET_DATARDY_Pos)) {
            }
            NRF_TEMP->EVENTS_DATARDY = 0;

            temperature = (uint8_t)(nrf_temp_read()/4);


            NRF_TEMP->TASKS_STOP = 1; /* Stop the temperature measurement */





            DEBUG("are we here %d \n ",counter);
            beaconPayload[21] = temperature;   //Major value 2
            beaconPayload[23] = counter; //Minor value 2
            ble.clearAdvertisingPayload();

            ble.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
            ble.accumulateAdvertisingPayload(GapAdvertisingData::MANUFACTURER_SPECIFIC_DATA, beaconPayload, sizeof(beaconPayload));
            ble.setAdvertisingType(GapAdvertisingParams::ADV_NON_CONNECTABLE_UNDIRECTED);
            ble.setAdvertisingInterval(16000); /* 1s; in multiples of 0.625ms. */
            ble.startAdvertising();

        } else {

            ble.waitForEvent();
        }

    }
}