#include "mbed.h"
#include "SRF05.h"
#include "DebouncedIn.h"
#include "rtos.h"
 
 
/*
Para este proyecto se crearán tres hilos:
 
1. Sensado - correspondiente al sensado de la distancia de la cabina con respecto al SRF05.
 
2. Botones - correspondiente a los 8 botones instalados en el ascensor:
- Tres de selección del piso deseado.
- Uno de paro de emergencia.
- Cuatro de llamado del ascensor en cada piso: uno en el primero (subir), uno en el tercero (bajar) y dos en el segundo (subir, bajar).
 
3. Pisos - correspondiente al llamado a cada uno de los pisos, dentro de su sección crítica se configurarán las salidas de los servos para la apertura de puertas en cada uno.
 
El recurso compartido será la disponibilidad del ascensor para ser llamado, el cual se llamará "disponible".
*/ 
 
// Declaración de puertos de transmisión y recepción para comunicación serial
Serial pc(USBTX, USBRX);
 
// Declaración de pines para las puertas a partir de salidas PWM
PwmOut servo1(PTD0);    // servo 1 - primer piso
PwmOut servo2(PTD5);    // servo 2 - segundo piso
PwmOut servo3(PTA13);    // servo 3 - tercer piso
int STOP=0;                     // estado detenido inicializado en 0
 
// variables de estado para el giro del motor DC - up, down
int motor_up;
int motor_down;
 
// Declaración de pines para los botones
DebouncedIn boton1(PTC11);      // Botón de llamado desde el primer piso
DebouncedIn boton2b(PTC10);     // Botón de llamado desde el segundo piso para bajar
DebouncedIn boton2s(PTC6);      // Botón de llamado desde el segundo piso para subir
DebouncedIn boton3(PTC5);       // Botón de llamado desde el tercer piso
DebouncedIn boton1i(PTC4);      // Botón para ir al primer piso
DebouncedIn boton2i(PTC3);      // Botón para ir al segundo piso
DebouncedIn boton3i(PTC0);      // Botón para ir al tercer piso
DebouncedIn boton_p(PTC7);      // Botón de paro
 
// Declaración pines del sensor de ultrasonido
SRF05 sensor(PTD3,PTD1);        // (Trigger, Echo)
 
// Declaración pines digitales para los led's indicadores de piso
DigitalOut led1(PTE5);          // piso 1
DigitalOut led2(PTE4);          // piso 2
DigitalOut led3(PTE3);          // piso 3
 
// Declaración pines de salida para el motor principal tipo PWM para inversión de giro
PwmOut ascender(PTC1);    
PwmOut bajada(PTC2);
DigitalOut enable(PTB3);  
    
// Hilos
Thread pul;
Thread sen;
Thread pis;
 
   
//A continuación se describe el número de botones a usar
// los pisos del ascensor, el botón de paro
// y las distancias entre los pisos
 
int i = 0;
int botones[4];                     // Botones de selección de piso
int pisos[3];                       // Número de pisos del ascensor
int paro;                           // variable de paro
int disponible=0;                   // Estado de ejecución del ascensor              
float distancia;                    // Distancia real medida del sensor
float dist_p3=8.0;                  // Distancia del sensor al piso 3
float dist_p2=28.0;                 // Distancia del sensor al piso 2
float dist_p1=47.0;                 // Distancia del sensor al piso 1
 
// Evaluación de estado de los pulsadores
void pulsadores(void const *args){
    
    while(1) {
        
        // Si se presiona el botón de paro se activa el estado detenido y el estado de paro
        if (boton_p.read()==1){    // Lectura de boton de paro
            STOP=1;           
            paro=1; 
            }
        // Si se presiona el botón de llamado desde el primer piso, es porque se activó el botón 0   
        if (boton1.read()==1){
            botones[0]=1; 
            }
        // Si se presiona el botón de llamado desde el segundo piso para bajar, es porque se activó el botón 1
        // Lo que hará que baje al primer piso 
        if (boton2b.read()==1){
            botones[1]=1;
            }
        // Si se presiona el botón de llamado desde el segundo piso para subir, es porque se activó el botón 2
        // Lo que hará que suba al tercer piso 
        if (boton2s.read()==1){
            botones[2]=1; 
            }
        // Si se presiona el botón de llamado desde tercer piso, es porque se activó el botón 3     
        if (boton3.read()==1){
            botones[3]=1; 
            }
        // Si se presiona el botón para ir al primer piso, la cabina se desplazará al primer piso
        if (boton1i.read()==1){
            pisos[0]=1; 
            }
        // Si se presiona el botón para ir al segundo piso, la cabina se desplazará al segundo piso
        if (boton2i.read()==1){
            pisos[1]=1; 
            }
        // Si se presiona el botón para ir al tercer piso, la cabina se desplazará al tercer piso
        if (boton3i.read()==1){
            pisos[2]=1; 
            }
      // Thread::wait(1000.0*0.02);
    }
}
 
// Función de lectura de distancia por el SRF05
void sensar(void const *args){
    
    while(1) {
        
        distancia=sensor.read();        // Lectura del sensor
        //Thread::wait(1000.0*0.02);
        distancia=floor(distancia); 
    }
}
void subir(void){ 
        ascender.period_ms(20);
        bajada.period_ms(20);
        ascender.pulsewidth_ms(15);
        bajada.pulsewidth_ms(0);
}
 
void bajar(void){
    
        ascender.period_ms(20);
        bajada.period_ms(20);
        ascender.pulsewidth_ms(0);
        bajada.pulsewidth_ms(8);
}
 
void parar(void){
        ascender.period_ms(20);
        bajada.period_ms(20);
        ascender.pulsewidth_ms(0);
        bajada.pulsewidth_ms(0);
 }
 
 
void puertas(void){
 
    // Para el primer piso
    if(pisos[0]==1){
        
        // Abrir puerta
        servo1.period(0.025);   
        servo1.pulsewidth(0.0008);
        wait(5);                // Duración apertura
        // Cerrar puerta
        servo1.period(0.025);   
        servo1.pulsewidth(0.0008);
        wait(5);
}
// Segundo Piso
else if(pisos[1]==1){
    // Abrir puerta
    servo2.period(0.025);   
            servo2.pulsewidth(0.0055);
            wait(5);                // Duración apertura
        // Cerrar puerta
        servo2.period(0.025);   
                servo2.pulsewidth(0.0008);
        wait(5);
}
// Tercer piso
            else{
        // Abrir
servo3.period(0.025);   
                servo3.pulsewidth(0.0055);
wait(5);                // Duración apertura
        // Cerrar
        servo3.period(0.025);   
                servo3.pulsewidth(0.0055);
wait(5);
}    
}
 
 
void reinicio(void){
    for(i=0;i==3;i++)
        {
            botones[i]=0;
            if(i!=3)
                pisos[i]=0;
            
        }
}
 
void piso (void const *args)
{   
    while(1)
    {
        if(botones[0]==1) //Llamado desde el primer piso
        {
            if(distancia<dist_p1)//si no esta en el primer piso, baja
            {
                bajar();
        }else{
            parar();
            puertas();
            botones[0]=0;
        }
    }//Fin botones[0]
 
    if(botones[1]==1) //Llamado desde el segundo piso para bajar
    {
        if(distancia<dist_p2)//si esta en el tercer piso, baja
        {
            bajar();
        }else if(distancia>dist_p2){// si esta en el primer piso sube
            subir();
 
        }else{  // en el segundo piso para y baja al primer piso
            parar();
            puertas();
            botones[1]=0;
            botones[0]=1;
        }
    }//Fin botones[1]
    
 
    if(botones[2]==1) //Llamado desde el segundo piso para subir
    {
        if(distancia<dist_p2)//si esta en el tercer piso, sube
        {
            subir();
        }else if(distancia>dist_p2){// si esta en el primer piso baja
            bajar();
 
        }else{  // en el segundo piso para y sube al tercer piso
            parar();
            puertas();
            botones[2]=0;
            botones[3]=1;
        }
    }//Fin botones[2]
 
    if(botones[3]==1) //Llamado desde el tercer piso
    {
        if(distancia>dist_p3)//si no esta en el primer tercer piso sube
        {
            subir();
        }else{
            parar();
            puertas();
            botones[3]=0;
        }
    }//Fin botones[3]
    
    if(pisos[0]==1)//Ir al piso 1
    {
        botones[0]=1;
        pisos[0]=0;
    }//Fin pisos [0]
    
    if(pisos[1]==1)//Ir al piso 2
    {
        if(distancia<dist_p2)//si esta en el tercer piso, sube
        {
            subir();
        }else if(distancia>dist_p2){// si esta en el primer piso baja
            bajar();
 
        }else{  // en el segundo piso para y sube al tercer piso
            parar();
            puertas();
            pisos[1]=0;
        }
 
    }//Fin pisos[1]
 
    if(pisos[2]==1)//Ir al piso 3
    {
        botones[3]=1;
        pisos[2]=0;
    }//Fin pisos [2]
    
    if(STOP==1)
    {
        parar();
        reinicio();
    }//Fin STOP
 
    }//Fin while
}//Fin piso 
 
int main(void)
{
 
    parar();
    pul.start(callback(pulsadores,(void *)"pulsa"));
    sen.start(callback(sensar,(void *)"sensor"));
    pis.start(callback(piso,(void *)"pisos"));
 
}//Fin main
 
