#include "mbed.h"
#include "nRF24L01P.h"
#include "PinDetect.h"
#include "neopixel.h"

#define TRANSFER_SIZE   1 // Was 4
#define SEND_TRUE       '1'
#define SEND_FALSE      '0'
#define THRESHOLD       0.5
#define DATA_PIN        p5
#define TEST_LENGTH     15
#define WAIT_TIME       5

//Activate button
PinDetect pb(p19);

//Analog Breath
AnalogIn breath(p20);

//Timer
Timer t;

//Debounce Timer 
Timer debounce;

//Transceiver
nRF24L01P nRF(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

//PC debug
Serial pc(USBTX, USBRX); // tx, rx

//Transmit Debugging
DigitalOut myled1(LED1); //Drunk 
DigitalOut myled2(LED2); //Sober

//Variables
char txData[TRANSFER_SIZE];
int txDataCnt = 0;

bool updateLights(int numPixels, neopixel::Pixel * pixels, neopixel::PixelArray array) {
    bool drunk = 0;
    int num_Pixels = 0;
    float value = breath.read();
    //pc.printf("Value: %f\n\r",breath.read());
    //wait(1);
    if (value > THRESHOLD) {
        drunk = 1;
    } else {
        drunk = 0;
    }
    num_Pixels = (int)ceil(value * 6);
    array.update(pixels, numPixels);
    if (!drunk) {
        for (int a = 1; a <= num_Pixels; a++) {
            pixels[a].green = 50; // green
            array.update(pixels, numPixels);
            //wait(.2);
        }
        for (int a = num_Pixels + 1; a < numPixels; a++) {
            pixels[a].red = 0; //green
            pixels[a].green = 0; //red
            array.update(pixels, numPixels);
        }
    } else {
        for (int a = 1; a <= 3; a++) {
            pixels[a].green = 50;
            array.update(pixels, numPixels);
            //wait(.2);
        }
        for (int a = 4; a <= num_Pixels; a++) {
            pixels[a].red = 50;
            array.update(pixels, numPixels);
            //wait(.2);
        }
        for (int a = num_Pixels + 1; a < numPixels; a++) {
            pixels[a].red = 0;
            pixels[a].green = 0;
            array.update(pixels, numPixels);
        }
    }
    wait(1);
    return drunk;
}

bool startTest(int sec) {
    //Pixel Init
    DigitalIn(p11, PullDown);
    neopixel::PixelArray array(p11);
    uint16_t numPixels = 7;
    neopixel::Pixel pixels[numPixels];
    pixels[0].red = 0;
    pixels[0].green = 0;
    pixels[0].blue = 50;
    for(int i = 1; i < numPixels; i++) { 
        pixels[i].red = 0;
        pixels[i].green = 0;
        pixels[i].blue = 0;
    }    
    //Test
    bool ifEverDrunk = false;
    t.start();
    while(t.read() < sec) {
        if (updateLights(numPixels, pixels, array)) { 
            ifEverDrunk = true;
            pc.printf("Updating Lights\r\n");
        }
    }
    t.stop();   
    t.reset();
    //Turn off LEDs
    for(int i = 0; i < numPixels; i++) { 
        pixels[i].red = 0;
        pixels[i].green = 0;
        pixels[i].blue = 0;
    }    
    array.update(pixels, numPixels);
    //return
    return ifEverDrunk;
}

void sendData(bool drunk){
    if (drunk) {
        txData[txDataCnt++] = SEND_TRUE;
        myled1 = !myled1;
    } else {
        txData[txDataCnt++] = SEND_FALSE;
        myled2 = !myled2;
    }
    if ( txDataCnt >= sizeof( txData ) ) {
        pc.printf("%c", txData[0]);
        nRF.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf(" Sending...\r\n");
        txDataCnt = 0;
    }
}

void pb_callback(void) {
    pc.printf("Callback\r\n");
    sendData(startTest(TEST_LENGTH));   
    wait(WAIT_TIME);
}

int main() {
    
    //RF and Push Button
    nRF.powerUp();
    nRF.setTransferSize(TRANSFER_SIZE);
    nRF.setTransmitMode();
    nRF.enable();
    pb.mode(PullUp);
    wait(.001);
    pb.attach_deasserted(&pb_callback);
    pb.setSampleFrequency();

    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  nRF.getRfFrequency() );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  nRF.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", nRF.getAirDataRate() );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", nRF.getTxAddress() );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", nRF.getRxAddress() );
    
    while(1) {
        pc.printf("Loop\r\n");  //Debug loop
    }
}
