#include "mbed.h"
#include "uLCD_4DGL.h"
#include "Webpage.h"
#include "LSM9DS1.h"
#include "playSound.h"
#include "SDFileSystem.h"
#include "wave_player.h"
#define PI 3.14159
#define DECLINATION -4.94 // Declination (degrees) in Atlanta,GA.

//DigitalIn pb1(p29);
//DigitalIn pb2(p30);
float TOL = 0.10;
int AWAKE_TOL = 4;
int MAX_AWAKE = 20;

Serial pc(USBTX, USBRX);
PwmOut red(p22);
PwmOut green(p23);
PwmOut blue(p24);
uLCD_4DGL uLCD(p28, p27, p30);
SDFileSystem sd(p11, p12, p13, p14, "sd");
Webpage page(p28, p27);
LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
AnalogOut DACout(p18);                  
wave_player player(&DACout); 

bool awake; 
bool isMoving;
int awakeLevel;
float prevAccx, prevAccy, prevAccz;
void initMain();


//playSound("/sd/wavfiles/BUZZER.wav");

int main() {
    page.init();
    initMain();
    
    IMU.begin();  
    initMain();
    
    while(1) {
        while(!IMU.accelAvailable());
        IMU.readAccel();
        //pc.printf("accel:   %9f %9f %9f in gs\n\r", IMU.calcAccel(IMU.ax) - prevAccx, IMU.calcAccel(IMU.ay)- prevAccy, IMU.calcAccel(IMU.az)- prevAccz);
        isMoving = (abs(IMU.calcAccel(IMU.ax)- prevAccx) > TOL) 
                || (abs(IMU.calcAccel(IMU.ay) - prevAccy) > TOL) 
                || (abs(IMU.calcAccel(IMU.az) - prevAccz) > TOL);
            
        if (isMoving) {
            if (awakeLevel < MAX_AWAKE) {
                awakeLevel++;
            }
        } else {
            if (awakeLevel > 0) {
                awakeLevel--;
            }
        }
        
        pc.printf("Moving = %d\n", isMoving);
        pc.printf("Awake = %d\n", awake);
        pc.printf("Activity = %d\n", awakeLevel);
        
        if (awakeLevel > AWAKE_TOL) {
            if (!awake) page.updateOutput(9001);
            awake = true;
            pc.printf("A\n");
        } else { 
            if (awake) page.updateOutput(0);
            pc.printf("B\n");
            awake = false;
        }
            
        prevAccx = IMU.calcAccel(IMU.ax);
        prevAccy = IMU.calcAccel(IMU.ay);
        prevAccz = IMU.calcAccel(IMU.az);
        
        page.update();
        if (page.getPlay()) playSound("/sd/Sleep.wav");
        
        wait(0.8);
        //pc.printf("mag:   %9f %9f %9f in gauss\n\r", IMU.calcAccel(IMU.ax), IMU.calcAccel(IMU.ay), IMU.calcAccel(IMU.az));
    }
}

void initMain() {
    awake = false;
    isMoving = false; 
    awakeLevel = 0;
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    while(!IMU.gyroAvailable());
    IMU.readGyro();
    prevAccx = IMU.calcAccel(IMU.ax);
    prevAccy = IMU.calcAccel(IMU.ay);
    prevAccz = IMU.calcAccel(IMU.az);
}
    
