#include "mbed.h"
#include <math.h>
#include "stdio.h"

AnalogIn arusIn(A0);
AnalogIn tegIn(A1);
AnalogIn arusOut(A2);
AnalogIn tegOut(A3);
AnalogIn suhuPv(A4);
AnalogIn suhuCore(A5);

DigitalOut led(LED1);

const int nGen = 24;
const double nGen1 = nGen;
const int nIndividu = 50;
const int nGenerasi = 40;
const float kSil = 0.75;
const float kMut = 0.5;

int kromInduk[nIndividu][nGen];
int kromKode[nIndividu][nGen];
float indeksGen[nIndividu][1];
float kromEval[nIndividu][nGen+2];
float kromUrut[nIndividu][nGen+2];
int r[nIndividu/2];
bool kromSel[nIndividu/2][nGen];
bool kromSilInduk[nIndividu/2][nGen];
bool kromSilAnak[nIndividu/2][nGen];
bool kromMut[nIndividu][nGen];
int arrayku[nGen];
const int nMut = kMut *nGen;
int chGen[nMut];
float kromUngGen[nGenerasi][nGen+1];
int kromUng[nGen];
float kromUngVal2;

int h,i,k,a,j,l,m,n,b,c,x;
float d,e;
const int bawah = pow(2,nGen1)- 1;

int xmin = 0;
float xmax = 22.1;

void bangkitGen(){
    
    //printf("\n1. Pembangkitan Kromosom Induk\n\r");

    for(m=0;m<nIndividu;m++){
        //Here I'd like to print each address field of each structure to the screen
        //printf("Kromosom ke-%d : ", m);
        for (n=0;n<nGen;n++){
            bool s = rand() % 2;
            kromInduk[m][n] = s;
            //printf("%i",kromInduk[m][n]);
        }
        //printf(" \n\r");
    }
    //printf(" \n\r");
}

void koding(){
  //printf("\n2. Pengkodean kromosom\n\r");
  
  for (m=0; m<nIndividu; m++){
    //printf("%d : ", m);
    float binerTotal = 0.00;
    for (n=0; n<nGen; n++){
      kromKode[m][n] = kromInduk[m][n];
      x = kromKode[m][n];
      binerTotal += x * pow(2,nGen1 - (n + 1));
      
      //printf("%i",kromInduk[m][n]);
    }
    float c = binerTotal /bawah;
    indeksGen[m][1] = (xmin + (xmax - xmin)) * c;
    d = indeksGen[m][1];
    //printf(", %.0f, %.2f", binerTotal, d);
    //printf(" \n\r");
  }
  //printf(" \n\r");
}

void evaluasi(){
  //printf("\n3. Evaluasi\n\r");
  bool f;
  float h;
  for (m=0; m<nIndividu; m++){
    //printf("%d : ", m);
    for (n=0; n<nGen; n++){
      kromEval[m][n] = kromKode[m][n];
      f = kromEval[m][n];
      //printf("%i",f);
    }
    
    float arusOut1;
    arusOut1 = arusOut.read() *10;
    float tegOut1;
    tegOut1 = tegOut.read() *12;
    float pOut;
    pOut = arusOut1 *tegOut1;
    kromEval[m][nGen] = indeksGen[m][1];
    kromEval[m][nGen+1] = pOut;
    h = kromEval[m][nGen+1];
    //printf(",%.2f", h);
    //printf(" \n\r");
  }
  //printf(" \n\r");
}

void maks(){
  int i;
  float maks = 0.00;
  int imaks = 0;
  float val;
  for (i=0; i<nIndividu; i++){
    val = kromUrut[i][nGen+1];
    if (val > maks){
      maks = val;
      imaks = i;
    }
    else{
      maks = maks;
      imaks = imaks;
    }
  }
  r[l] = imaks;
  //printf("%i, %.2f: ", imaks, maks);
  for (n=0; n<nGen; n++){
    int ag = kromUrut[imaks][n];
    kromSel[l][n] = ag;
    kromUrut[imaks][nGen+1] = 0;
    //printf("%i",ag);
  }
  //printf(" \n\r");
}

void urut(){
  //printf("\n4. Seleksi\n\r");
  for (m=0; m<nIndividu; m++){
    for (n=0; n<=(nGen+1); n++){
      kromUrut[m][n] = kromEval[m][n];
    }
  }

  for (l=0; l<(nIndividu/2); l++){
    maks();
  }
  //printf(" \n\r");
}

void silang(){
  //printf("\n5. Penyilangan\n\r");
  //printf("\nInduk\n\r");

  for (m=0; m<nIndividu/2; m++){
    for (n=0; n<nGen; n++){
      int sx = kromSel[m][n];
      //printf("%i",sx);
      kromSilInduk[m][n] = sx;
    }
    //printf(" \n\r");
  }
  //printf(" \n\r");
  //printf("\nAnak\n\r");
  int pSil = kSil *nGen;
  for (m=0; m<nIndividu/4; m++){
    for (int ma=0; ma<pSil; ma++){
      int ms1 = kromSilInduk[m*2][ma];
      kromSilAnak[m*2][ma] = ms1;
      int ms2 = kromSilInduk[(m*2)+1][ma];
      kromSilAnak[(m*2)+1][ma] = ms2;
    }
    for (int mb=pSil; mb<=nGen; mb++){
      int mb1 = kromSilInduk[(m*2)+1][mb];
      kromSilAnak[m*2][mb] = mb1;
      int mb2 = kromSilInduk[m*2][mb];
      kromSilAnak[(m*2)+1][mb] = mb2;
    }
  }
  for (int ma=0; ma<pSil; ma++){
    int ms1 = kromSilInduk[0][ma];
    kromSilAnak[0][ma] = ms1;
    int ms2 = kromSilInduk[1][ma];
    kromSilAnak[1][ma] = ms2;
  }
  for (int mb=pSil; mb<=nGen; mb++){
    int mb1 = kromSilInduk[1][mb];
    kromSilAnak[0][mb] = mb1;
    int mb2 = kromSilInduk[0][mb];
    kromSilAnak[1][mb] = mb2;
  }

  for (m=0; m<nIndividu/2; m++){
    for (n=0; n<nGen; n++){
      int cb1 = kromSilAnak[m][n];
      //printf("%i",cb1);
    }
    //printf(" \n\r");
  }
  //printf(" \n\r");
}

void genArray(){
  for (int r=0; r<nGen; r++){
    arrayku[r] = r;
  }
}

void pickRandom(){
  genArray();
  for (int i=0; i<(nGen-nMut); i++){
    int ame = (nGen-1)-i;
    int choosen = rand() % ame;
    arrayku[choosen] = 0;

    for (int l=choosen; l<nGen; l++){
      int m = arrayku[l+1];
      arrayku[l] = m;
    }
    
  }
  
  //printf("Nomor gen termutasi: ");
  for (int q=0; q<nMut; q++){
    chGen[q] = arrayku[q];
    int p = chGen[q];
    //printf("%i,",p);
  }
  //printf(" \n\r");
}

void mutasi(){
  //printf("\n6. Mutasi\n\r");
  pickRandom();
  
  for (m=0; m<nIndividu/2; m++){
    for (n=0; n<nGen; n++){
      int sy = kromSilInduk[m][n];
      kromMut[m][n] = sy;
    }
  }
  for (m=nIndividu/2; m<=nIndividu; m++){
    for (n=0; n<nGen; n++){
      int sh = kromSilAnak[m - (nIndividu/2)][n];
      kromMut[m][n] = sh;
    }
  }
  
  for (m=0; m<nIndividu; m++){
    for (n=0; n<nGen; n++){
    }
  }

  for (int s=0; s<nIndividu; s++){
    for (int t=0; t<nMut; t++){
      int u = chGen[t];
      if (kromMut[s][u]==1){
        kromMut[s][u] = 0;
      }
      else{
        kromMut[s][u] = 1;
      }
    }
  }

  printf(" \n\r");

  for (int v=0; v<nIndividu; v++){
    for (int x=0; x<nGen; x++){
      int wa = kromMut[v][x];
      //printf("%i",wa);
    }
    //printf(" \n\r");
  }
}

void maksGen(){
  float maks = 0.00;
  int imaks = 0;
  float val;
  for (i=0; i<nGenerasi; i++){
    val = kromUngGen[i][nGen];
    if (val > maks){
      maks = val;
      imaks = i;
    }
    else{
      maks = maks;
      imaks = imaks;
    }
  }
  printf("Generasi ke- %i\n\r", imaks);
  printf("Nilai fitness : %.2f\n\r", maks);
  printf("Kromosom :  ");
  for (n=0; n<nGen; n++){
    int ag = kromUngGen[imaks][n];
    kromUng[n] = ag;
    kromUrut[imaks][nGen] = 0;
    printf("%i", ag);
  }
  printf(" \n\r");
  float binerTotal = 0.00;
  for (n=0; n<nGen; n++){
    x = kromUng[n];
    binerTotal += x * pow(2,nGen1 - (n + 1));
  }
  float c = binerTotal /bawah;
  float vRep = (xmin + (xmax - xmin)) * c;
  printf("Nilai representasi :  %.2f\n\r", vRep);
}

void urutGen(){
  printf(" \n\r");
  printf("\nKromosom unggul tercapai pada : \n\r");
  for (m=0; m<nGenerasi; m++){
    for (n=0; n<=(nGen); n++){
      kromUrut[m][n] = kromUngGen[m][n];
    }
  }
  maksGen();
}

int main()
{
  printf("\n----------ALGORITMA GENETIKA - MPPT----------\n\r");
  float kromUngVal;
  
  float suhuPv1;
  suhuPv1 = suhuPv.read();
  float suhuCore1;
  suhuCore1 = suhuCore.read();
  printf("\nSuhu PV : %.2f\n\r", suhuPv1);
  printf("Suhu Core : %.2f\n\r", suhuCore1);
  
  bangkitGen();
  printf("\nKromosom unggul setiap generasi :\n\r");
  for (i=0; i<nGenerasi; i++){
    led = 1;
    koding();
    evaluasi();
    urut();
    silang();
    mutasi();
    led = 0;
  
    for (m=0; m<nIndividu; m++){
      for (n=0; n<nGen; n++){
        kromInduk[m][n] = kromMut[m][n];
      }
    }
    koding();
    evaluasi();
    urut();
    
    printf(" Generasi ke-%d : ", i);
    for (m=0; m<nGen; m++){
      kromUngGen[i][m] = kromSel[0][m];
      printf("%.0f",kromUngGen[i][m]);
    }
    kromUngVal = kromEval[r[0]][nGen+1];
    kromUngGen[i][nGen] = kromUngVal;
    
    kromUngVal2 = kromUngGen[i][nGen];
    printf(" : %.2f", kromUngVal2);
    printf(" \r");
    
  }
  urutGen();
}