/*! \file const.h
\brief A Documented file.
* name:   const.h    Version: 2.0 \n
* author: PE HTL BULME \n
* email:  pe@bulme.at \n
* description:
*   Constants for ur_Bertl The Robot
*   Constant for Robot from objectiv Robot added
*/
#ifndef CONST_H
#define CONST_H
#define TIME
const int MOVE=500;
const int TURN=500;

/*! \var int ULTRASONIC_DISTANCE
\brief Bertl Ultrasonic Distance Sensor from 1 to n; 5 is ok for nearly 5 cm.
\warning no warning*/
const int ULTRASONIC_DISTANCE = 5;    /*  Distance sensor  */
/*! \var int SPEED
\brief Bertl speed 0.2 (slow) - 1.0 (fast).
\warning speed below 0.2 possible the motor won't start */
const float SPEED = 0.2;    /*  Bertl speed 0.2 (slow) - 1.0 (fast) */
/*! \var int DISTANCE
\brief one wheel turn is appr. 24 ticks.
\warning maybe the number has to be adjusted */
const int DISTANCE = 12;    /*  one wheel turn is appr. 24 ticks */
/*! \var int ANGLE
\brief 12 is nearly 90 degree turn left.
\warning maybe the number has to be adjusted */
const int ANGLE = 12;       /*  nearly 90 degree turn left */

const int BTN_FLL = 0x80;   //  button front left outer 
const int BTN_FL  = 0x04;   // button front left
const int BTN_FM  = 0x01;   // button front middle
const int BTN_FR  = 0x08;   // button front right 
const int BTN_FRR = 0x40;   // button front right outer
const int BTN_BL  = 0x10;   // button back left
const int BTN_BM  = 0x02;   // button back middle
const int BTN_BR  = 0x20;   // button back right

const int LED_FL1 = 0x01;   /**<  front LED white */
const int LED_FL2 = 0x02;   /**< front LED yellow */
const int LED_FR1 = 0x04;   /**< front LED white */
const int LED_FR2 = 0x08;   /**< front LED yellow */
const int LED_ALL_FRONT = 0x0F;

const int LED_BL1 = 0x20;   /**< yellow LED back left outer */
const int LED_BL2 = 0x10;   /**< red LED back left inner */
const int LED_BR1 = 0x80;   /**< yellow LED back right outer */
const int LED_BR2 = 0x40;   /**< red LED back right inner */
const int LED_ALL_BACK = 0xF0;
const int LED_ALL = 0xFF;

const int LED_BLUE = 0xBB;

const int addr = 0x40;       // I2C-address PCA9555
const int PERIOD = 20;       // PWM period
const int PULSWIDTH = 5;     // PWN pulswidth
const int East = 1; 
const int West = 2; 
const int North = 3;
const int South = 4;


#endif