// Chris Powers - Youtube Channel:
// https://www.youtube.com/user/pwr1337
// --------------------------------------
// How it's done:
// https://youtu.be/_DPzgBKBpLo
// -------------------------------------- 
// Version 0.1                 11.06.2020
// --------------------------------------


#include "mbed.h"
// Include header file from our class DHT11
#include "DHT11.h"
// Serial interface to print the data
Serial pc(USBTX, USBRX, 115200);
// New object of our newly created class "DHT11"
DHT11 sensor(D8);



int main(void)
{
    // Welcome message
    pc.printf("\nDHT11 - Sensordata\n");
    // Array to store the data from the sensor [0]-> Humidity   [1]-> Temperature
    float sensor_data[2];
    // Variable to store the return value of the DHT11::getData() function 
    int8_t checker = 0;
    // Main loop
    while(true)
    {
        //  get return value and retrieve data from the sensor to the float array
        checker = sensor.getData(sensor_data);
        // return 1 ->  everything worked as intended
        if(checker == 1)
        {
            // print the measured values to the serial interface
            pc.printf("Luftfeuchtigkeit: %.0f Prozent\n", sensor_data[0]);
            pc.printf("Temperatur:       %.1f Grad\n", sensor_data[1]);
        }
        // return -1 -> Connection error, maybe the device is not connected properly    
        else if(checker == -1)      pc.printf("Connection Error\n");
        // return -2 -> Checksum Error, maybe corrupted data
        else if(checker == -2)      pc.printf("CheckSum Error\n"); 
        // do not send any instruction to the sensor in within one second in order to pass the unstable status  
        wait(1.1);
    }
    
    return 0;
}