#include "DHT11.h"

int8_t DHT11::getData(float *sensor_data)
{
    // First start condition - warm up
    while(start_up.read_ms() < 1500) {}
    start_up.stop();
    // Timer to measure the time while the signal is HIGH
    Timer get_time;
    // Array for the raw data from DHT11
    uint8_t raw_data[5];
    for(int x=0; x<5; x++)  raw_data[x] = '\0';
    
    // Counter variables
    uint8_t bit_counter = 0;
    uint8_t byte_counter = 0;
    int16_t timeout_counter = 0;
    
    // Handshake
    dht_bus.output();
    dht_bus.write(0);
    wait_ms(20);
    dht_bus.input();
    
    // Catch the rest of the handshake, with timeout proof 
    timeout_counter = 10000;
    while(dht_bus.read() == 1) {if(timeout_counter-- == 0) return -1;}
    timeout_counter = 10000;
    while(dht_bus.read() == 0) {if(timeout_counter-- == 0) return -1;}
    timeout_counter = 10000;
    while(dht_bus.read() == 1) {if(timeout_counter-- == 0) return -1;}
    
    // Loop to read the 40 bits from the DHT11 databus
    for(int x=0; x<40; x++)
    {
        get_time.reset();
        timeout_counter = 10000;
        while(dht_bus.read() == 0) {if(timeout_counter-- == 0) return -1;}
        // start the timer to measure the time of the HIGH signal
        get_time.start();
        timeout_counter = 10000;
        while(dht_bus.read() == 1) {if(timeout_counter-- == 0) return -1;}
        // if the signal is LOW stop the timer
        get_time.stop();
        // MSB comes first so we have to bitshift the data each loop
        raw_data[byte_counter] <<= 1;
        // If the time of the HIGH state from the signal is greater 50us add "1" to binary number
        if(get_time.read_us() > 50) raw_data[byte_counter] += 1;
        // counter for the bit position of the binary number
        bit_counter++;
        // reset bit counter and increment the byte counter if 1 byte is reached - 8 bit 
        if(bit_counter == 8)
        {
            bit_counter = 0;
            byte_counter++;
        }
        
        
    }
    
    // Checksum calculation
    if((raw_data[0] + raw_data[1] + raw_data[2] + raw_data[3]) != raw_data[4])  return -2; 
    
    // Sensor data - combine integral and decimal data
    sensor_data[0] = (float)raw_data[0] + (float)raw_data[1] / 10.0f;
    sensor_data[1] = (float)raw_data[2] + (float)raw_data[3] / 10.0f;
    
    
    return 1;
}