
#ifndef DHT11_H
#define DHT11_H

#include "mbed.h"

class DHT11
{
private:
    // Databus pin
    DigitalInOut dht_bus;
    // Timer for the warm up period
    Timer start_up;

public:
    // Constructor 
    // Parameter _dht_bus - nucleo pin for DHT11 databus
    DHT11(PinName _dht_bus):dht_bus(_dht_bus)
    {
        // Startup Timer, to pass the instable phase of DHT11 - warm up
        start_up.reset();
        start_up.start();
    }
    // Member function to read the data from DHT11
    // Parameter sensor_data - pointer to float array with length two: sensor_data[0] = humidity, sensor_data[1] = temperature
    // return 8-bit signed integer [1 OK, -1 Connection Error, -2 CheckSum Error] 
    int8_t getData(float *sensor_data);

};


#endif 