#include "mbed.h"

// PIN fur the databus from the DHT11 sensor
DigitalInOut dht_bus(D8);
// Serial Interface to print data
Serial pc(USBTX, USBRX, 115200);

// Prototyping
int getData(void);

// Function to read 40 bit Data from the DHT11
int getData(void)
{
    Timer get_time;
    // Array to store the length of the HIGH signal
    int times[40];
    // Array to store the integral and decimal parts of the temperature and humidity
    char sensor_data[5];
    // Write a zero to each field
    for(int x=0;x<5;x++)    sensor_data[x] = 0;
    // Variable to check for infinite loop
    int timeout_counter = 0;
    // Count the position of the bit
    int bit_count = 0;
    // Count the position og the byte
    int byte_count = 0;
    // Initialize handshake [see datasheet]
    dht_bus.output();
    dht_bus.write(0);
    wait_ms(20);
    dht_bus.input();
    
    // Capture the rest of the handshake from DHT11 
    timeout_counter = 10000;
    while(dht_bus.read() == 1) {if(timeout_counter-- == 0) return -1;}
    timeout_counter = 10000;
    while(dht_bus.read() == 0) {if(timeout_counter-- == 0) return -1;}
    timeout_counter = 10000;
    while(dht_bus.read() == 1) {if(timeout_counter-- == 0) return -1;}
    
    // Read the 40 bits Data from DHT11
    for(int x=0;x<40;x++)
    {
        // Reset the timer
        get_time.reset();
        // Wait until the signal changes from LOW to HIGH
        timeout_counter = 10000;
        while(dht_bus.read() == 0) {if(timeout_counter-- == 0) return -1;}
        // Start measuring the time until the signal changes from HIGH to LOW
        get_time.start();
        timeout_counter = 10000;
        while(dht_bus.read() == 1) {if(timeout_counter-- == 0) return -1;}
        get_time.stop();
        // Temp variable for the length of the HIGH signal
        int times_temp = get_time.read_us();
        // Write length in us in the array at the actual postition of the 40 bit data
        times[x] = times_temp;
        // Shift for 1 bit each loop
        sensor_data[byte_count] <<= 1;
        // If the value is 1 add a 1 to the binary number
        if(times_temp >= 50)       sensor_data[byte_count] += 1;
        bit_count++;
        // Check if the byte is complete and change to the next
        if(bit_count == 8)
        {
            bit_count = 0;
            byte_count++;     
        }
        
    }
    
    // Test output for the length of the HIGH Signal 
    pc.printf("\nHigh Times:\n");
    for(int x=0;x<40;x++)
    {
        pc.printf("%i ", times[x]);
    }
    
    // Test output for the binary code
    pc.printf("\nBinary\n");
    for(int x=0;x<40;x++)
    {
        if(times[x] >= 60)      printf("1 ");
        else                    printf("0 ");
        
        if((x+1)%8 == 0)        printf("\n");
    }
    
    // Test output for the integral and decimal parts of the temperature and humidity
    pc.printf("\nNumbers\n");
    for(int x=0;x<5;x++)
    {
        pc.printf("%i \n", sensor_data[x]);
    }
    
    // Calculate checksum and compare it with the checksum from the DHT11
    int check_sum = sensor_data[0] + sensor_data[1] + sensor_data[2] + sensor_data[3];
    pc.printf("\nChecksum: %i \n", check_sum);
    if(check_sum == sensor_data[4])  printf("Checksum OK\n");
    else                             return -2;
    
    // Test output for the infinite loop variable
    pc.printf("timeout_counter: %i \n", timeout_counter);
    
    // Test output for the calculated numbers for the temperature and humidity 
    float temperature = (float)sensor_data[2] + (float)sensor_data[3] / 10.0f;
    float humidity = (float)sensor_data[0] + (float)sensor_data[1] / 10.0f;
    pc.printf("Temperature: %.1f GradC\n", temperature);
    pc.printf("Humidity: %.1f Prozent\n", humidity);
    
    
    return 1;
}




int main(void)
{
    // Welcome message
    pc.printf("\nDHT11 - Funktionsweise\n");
    
    while(1)
    {
        int return_data = getData();
        // check the return value
        if(return_data == -1)       printf("Connection Error\n");
        else if(return_data == -2)  printf("CheckSum Error\n");
        // At least 1.1 seconds, the DHT11 sensor need 1 second to pass the instable status
        wait(2);
    }
    
    return 0;
}