#include "mbed.h"
#include "i2c.h"
//#include "mcp4728.h"

//-- PIN DEFINITIONS ----------------------------------------------------------------------------------
I2C i2c1(P1_6, P1_7);    // Enable I2C Master 1(SDA, SCL)
//I2C i2c2(P5_7, P6_0);    // Enable I2C Master 2(SDA, SCL)

//-- VARIABLES ----------------------------------------------------------------------------------------
extern char I2C1_TXDATA[];
extern char I2C1_RXDATA[];
//extern char I2C2_TXDATA[];
//extern char I2C2_RXDATA[];

void Init_I2C()
{
    i2c1.frequency(400000);     // Set I2C Bus = 400KHz
    //i2c2.frequency(400000);     // Set I2C Bus = 400KHz
}

char I2C_Quick_Write(char port, char address)
{
    // Device present should respond with 0x01, otherwise 0x00
    char RESPONSE = 0x00;
    port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    {
        //i2c2.start();
        //RESPONSE = i2c2.write(address);                         // Echo ACK/NACK Status
        //i2c2.stop();
    }
    else
    {
        i2c1.start();
        RESPONSE = i2c1.write(address);                         // Echo ACK/NACK Status
        i2c1.stop();
    }
    
    return RESPONSE;    
}

char I2C_Read_Byte(char port, char address, char reg)
{
    char RESPONSE = 0x00;
    port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    {
        //I2C2_TXDATA[0] = reg;                                   // Which register?
        //(void)i2c2.write(address, I2C2_TXDATA, 1, true);
        //(void)i2c2.read(address, I2C2_RXDATA, 1);               // Ask for data
        //wait_us(25);                                            // Wait for it
        //RESPONSE = I2C2_RXDATA[0];                              // Return Data                          
    }
    else
    {
        I2C1_TXDATA[0] = reg;                                   // Which register?
        (void)i2c1.write(address, I2C1_TXDATA, 1, true);
        (void)i2c1.read(address, I2C1_RXDATA, 1);               // Ask for data
        wait_us(25);                                            // Wait for it
        RESPONSE = I2C1_RXDATA[0];                              // Return Data
    }
                       
    return RESPONSE;
}

char I2C_Write_Register(char port, char address, char reg, char data)
{
    char RESPONSE = 0x00;
    port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    { 
        //I2C2_TXDATA[0] = reg;                                   // Register
        //I2C2_TXDATA[1] = data;                                  // Data
        //RESPONSE = i2c2.write(address,I2C2_TXDATA,2);           // Echo ACK/NACK
    }
    else
    {
        I2C1_TXDATA[0] = reg;                                   // Register
        I2C1_TXDATA[1] = data;                                  // Data
        RESPONSE = i2c1.write(address,I2C1_TXDATA,2);           // Echo ACK/NACK
    }
                       
    return RESPONSE;    
}

unsigned short I2C_Read_Word(char port, char address, char reg)
{
    unsigned short RESPONSE = 0x0000;
    port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    {
        //I2C2_TXDATA[0] = reg;                                                   // Which register?
        //(void)i2c2.write(address, I2C2_TXDATA, 1, true);
        //(void)i2c2.read(address, I2C2_RXDATA, 2);                               // Ask for data
        //wait_us(25);                                                            // Wait for it
        
        //RESPONSE = (unsigned short)((I2C2_RXDATA[0] * 256) + I2C2_RXDATA[1]);   // Return Data                          
    }
    else
    {
        I2C1_TXDATA[0] = reg;                                                   // Which register?
        (void)i2c1.write(address, I2C1_TXDATA, 1, true);
        (void)i2c1.read(address, I2C1_RXDATA, 2);                               // Ask for data
        wait_us(25);                                                            // Wait for it
        
        RESPONSE = (unsigned short)((I2C1_RXDATA[0] * 256) + I2C1_RXDATA[1]);   // Return Data 
    }
                       
    return RESPONSE;
}

char I2C_Write_Word(char port, char address, char reg, char hbyte, char lbyte)
{
    char RESPONSE = 0x00;
    port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    { 
        //I2C2_TXDATA[0] = reg;                                       // Register
        //I2C2_TXDATA[1] = hbyte;                                     // HB Data
        //I2C2_TXDATA[2] = lbyte;                                     // LB Data
        //RESPONSE = i2c2.write(address,I2C2_TXDATA,3);               // Echo ACK/NACK
    }
    else
    {
        I2C1_TXDATA[0] = reg;                                       // Register
        I2C1_TXDATA[1] = hbyte;                                     // HB Data
        I2C1_TXDATA[2] = lbyte;                                     // LB Data
        RESPONSE = i2c1.write(address,I2C1_TXDATA,3);               // Echo ACK/NACK
    }
                       
    return RESPONSE;    
}

void I2C_Write_Byte(char address, char data)
{
    I2C1_TXDATA[0] = data;                                          // Data
    (void)i2c1.write(address,I2C1_TXDATA,1);
    wait_us(10);                                                    // Wait for Mux to settle   
}


char I2C_Write_Block(char port, char address, char nbytes)
{
    char RESPONSE = 0x00;
    port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    { 
        //RESPONSE = i2c2.write(address,I2C2_TXDATA,nbytes + 1);               // Echo ACK/NACK 
    }
    else
    {
        RESPONSE = i2c1.write(address,I2C1_TXDATA,nbytes + 1);               // Echo ACK/NACK
    }
                       
    return RESPONSE;    
}


/*
char I2C_Write_Fast(char port, char address, char daca_hb, char daca_lb, char dacb_hb, char dacb_lb, char dacc_hb, char dacc_lb, char dacd_hb, char dacd_lb)
{
    char RESPONSE = 0x00;
    //port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    { 
        I2C2_TXDATA[0] = daca_hb;                                   // DAC_A High Byte
        I2C2_TXDATA[1] = daca_lb;                                   // DAC_A Low Byte
        I2C2_TXDATA[2] = dacb_hb;                                   // DAC_B High Byte
        I2C2_TXDATA[3] = dacb_lb;                                   // DAC_B Low Byte
        I2C2_TXDATA[4] = dacc_hb;                                   // DAC_C High Byte
        I2C2_TXDATA[5] = dacc_lb;                                   // DAC_C Low Byte
        I2C2_TXDATA[6] = dacd_hb;                                   // DAC_D High Byte
        I2C2_TXDATA[7] = dacd_lb;                                   // DAC_D Low Byte
        RESPONSE = i2c2.write(address,I2C2_TXDATA,3);               // Echo ACK/NACK
    }
    else
    {
        I2C1_TXDATA[0] = daca_hb;                                   // DAC_A High Byte
        I2C1_TXDATA[1] = daca_lb;                                   // DAC_A Low Byte
        I2C1_TXDATA[2] = dacb_hb;                                   // DAC_B High Byte
        I2C1_TXDATA[3] = dacb_lb;                                   // DAC_B Low Byte
        I2C1_TXDATA[4] = dacc_hb;                                   // DAC_C High Byte
        I2C1_TXDATA[5] = dacc_lb;                                   // DAC_C Low Byte
        I2C1_TXDATA[6] = dacd_hb;                                   // DAC_D High Byte
        I2C1_TXDATA[7] = dacd_lb;                                   // DAC_D Low Byte
        RESPONSE = i2c1.write(address,I2C1_TXDATA,8);               // Echo ACK/NACK
    }
                       
    return RESPONSE;    
}
*/

/*
char I2C_Write_Block(char port, char address, char reg, char byte1, char byte2, char byte3, char byte4, char byte5, char byte6, char byte7, char byte8)
{
    char RESPONSE = 0x00;
    //port = I2C_PORT1;
    
    if(port == I2C_PORT2)
    { 
        I2C2_TXDATA[0] = reg;                                       // Register
        I2C2_TXDATA[1] = byte1;                                     // Byte 1
        I2C2_TXDATA[2] = byte2;                                     // Byte 2
        I2C2_TXDATA[3] = byte3;                                     // Byte 3
        I2C2_TXDATA[4] = byte4;                                     // Byte 4
        I2C2_TXDATA[5] = byte5;                                     // Byte 5
        I2C2_TXDATA[6] = byte6;                                     // Byte 6
        I2C2_TXDATA[7] = byte7;                                     // Byte 7
        I2C2_TXDATA[8] = byte8;                                     // Byte 8
        RESPONSE = i2c2.write(address,I2C2_TXDATA,3);               // Echo ACK/NACK
    }
    else
    {
        I2C1_TXDATA[0] = reg;                                       // Register
        I2C1_TXDATA[1] = byte1;                                     // Byte 1
        I2C1_TXDATA[2] = byte2;                                     // Byte 2
        I2C1_TXDATA[3] = byte3;                                     // Byte 3
        I2C1_TXDATA[4] = byte4;                                     // Byte 4
        I2C1_TXDATA[5] = byte5;                                     // Byte 5
        I2C1_TXDATA[6] = byte6;                                     // Byte 6
        I2C1_TXDATA[7] = byte7;                                     // Byte 7
        I2C1_TXDATA[8] = byte8;                                     // Byte 8
        RESPONSE = i2c1.write(address,I2C1_TXDATA,9);               // Echo ACK/NACK
    }
                       
    return RESPONSE;    
}
*/


/*
unsigned short I2C_Read_Block(char address, char reg, int nbytes)
{
    unsigned short RESPONSE = 0x0000;
    
    I2C1_TXDATA[0] = reg;                                           // Which register?
    (void)i2c.write(address, I2C1_TXDATA, 1, true); 
    (void)i2c.read(address,I2C1_RXDATA,nbytes);
    
    switch(reg)
    {
        case DAC_A:
            RESPONSE = (unsigned short)(((I2C1_RXDATA[1] & 0x0F) * 256) + I2C1_RXDATA[2]);   // Return DAC A Data
            break;
        case DAC_B:
            RESPONSE = (unsigned short)(((I2C1_RXDATA[7] & 0x0F) * 256) + I2C1_RXDATA[8]);   // Return DAC B Data
            break;
        case DAC_C:
            RESPONSE = (unsigned short)(((I2C1_RXDATA[13] & 0x0F) * 256) + I2C1_RXDATA[14]); // Return DAC C Data
            break;
        case DAC_D:
            RESPONSE = (unsigned short)(((I2C1_RXDATA[19] & 0x0F) * 256) + I2C1_RXDATA[20]); // Return DAC D Data
            break;
        default:
            break;
    }
    
    return RESPONSE;    
}
*/