#define I2C_SDA p3
#define I2C_SCL p4
#define BAT_SENSE p1

#include "mbed.h"
#include "BLE.h"
#include "LampService.h"
#include "BatteryService.h"

BLE ble;

PwmOut light(LED1);
AnalogIn battery(BAT_SENSE);


const static char DEVICE_NAME[] = "Lemp";

static const uint16_t serviceList[] = {
    GattService::UUID_ENVIRONMENTAL_SERVICE, 
    GattService::UUID_BATTERY_SERVICE
};

void disconnectionCallback(const Gap::DisconnectionCallbackParams_t *params)
{
    /* Restart Advertising on disconnection*/
    ble.gap().startAdvertising();
}


int main(void)
{
    printf("Start\n");
    
    light = 1;
    
    ble.init();
    ble.gap().onDisconnection(disconnectionCallback);

    /* Setup weather service. */
    LampService lampService(ble);
    BatteryService batteryService(ble, 0);
+
    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    //TODo add lamp service to the list
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)serviceList, sizeof(serviceList));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    ble.gap().setAdvertisingInterval(500); /* 1000ms */
    ble.gap().startAdvertising();

//    light.period(0.0005f);
//    light.write(0.98f);   
         
    while (true) {
        if (ble.getGapState().connected) {
            uint8_t buffer[1];
            uint16_t lenght=sizeof(uint8_t);

            ble.gattServer().read(lampService.lightLevelCharacteristic.getValueHandle(), buffer, &lenght);
            
            int lightLevel = (int)buffer[0];
            
            if (lightLevel > 0) {
                light = 0;
            }
            else {
                light = 1;
            }
            
            // Voltage divider ratio on TinyBLE's battery sense is 18% for some reason (R1 = 10M, R2 = 2.2M)
            // So, on 3.3V the ADC will indicate only 18% capacity. We remap so that 18% is 100%
            // PS: battery = 0->1
            float batteryLvl = ((battery.read() * 100.0f) * 100.0f) / 18.0f;
            
            if (batteryLvl > 100) {
                batteryLvl = 100.0f;
            }
                                    
            batteryService.updateBatteryLevel(batteryLvl);
        } 
        else {
            ble.waitForEvent();
        }
    }
}
