#include "mbed.h"
#include "Serial_HL.h"
#include "BtnEventM0.h"
#include "FunkGen.h"

SerialBLK pc(USBTX, USBRX);
SvProtocol ua0(&pc);

void CommandHandler();

SignedRampGen fg1;
float ampl=1.0, v1=0.0;

// 2ter Generator + Variablen
TriangleGen fg2;
float ampl2=1.0, v2=0.0;

// RectangleGen
RectangleGen fg3;
float ampl3=1.0, v3=0.0;

void ExecSignalChain();

int main(void)
{
    pc.format(8,SerialBLK::None,1);
    pc.baud(115200);

    ua0.SvMessage("FuncGenMain"); // Meldung zum PC senden


    Timer stw;
    stw.start();
    while(1) {
        CommandHandler();

        if( ua0.acqON && (stw.read_ms()>10) ) { // 100Hz
            // dieser Teil wird mit 10Hz aufgerufen
            stw.reset();
            ExecSignalChain();
            if( ua0.acqON ) {

                ua0.WriteSV(1, v1);
                ua0.WriteSV(2, v2);
                ua0.WriteSV(3, v3);
            }
        }
    }
    return 1;
}

void ExecSignalChain()
{
    fg1.CalcOneStep();
    v1 = fg1.val*ampl; 
    
    // 2ten Generator rechnen  
    fg2.CalcOneStep();
    v2 = fg2.val*ampl2; 
    
    fg3.CalcOneStep();
    v3 = fg3.val*ampl3;
}

void CommandHandler()
{
    uint8_t cmd;

    if( !pc.IsDataAvail() )
        return;
    cmd = ua0.GetCommand();

    if(cmd==2)  // Set Frequ
    {
        fg1.SetFrequ(ua0.ReadF());
        fg2.SetFrequ(ua0.ReadF());
        fg3.SetFrequ(ua0.ReadF());
        ua0.SvMessage("SetFrequ");
    }

    if(cmd==3)  // Set Ampl
    {
        ampl = ua0.ReadF();
        ampl2 = ua0.ReadF();
        ampl3 = ua0.ReadF();
        ua0.SvMessage("SetAmpl");
    }
    
    // Amplitude und Frequenz auch für 2ten Generator setzen
}


