#ifndef FUNKGEN_h
#define FUNKGEN_h

class SignedRampGen
{
    public:
        float val;  // momentaner Ausgangswert
    private:
        float _inc;
    public:
        SignedRampGen();
        
        
        void SetPointsPerPeriod(float aPoint);
        
        // bezogen auf   Fsample 0..0.5
        void SetFrequ(float aFrequ);
        
        //Einen Abtastwert berechnen
        // wird bei z.B. Fsample=100Hz 100x pro Sec aufgerufen
        void CalcOneStep();  
};

class TriangleGen
{
    public:
        float val;  // momentaner Ausgangswert
    private:
        float _inc;
        int _state;
        float _phase;   // Ausgangswert des zugrundeliegenden Generators 
    public:
        TriangleGen();
        
        
        void SetPointsPerPeriod(float aPoint);
        
        // bezogen auf   Fsample 0..0.5
        void SetFrequ(float aFrequ);
        
        //Einen Abtastwert berechnen
        // wird bei z.B. Fsample=100Hz 100x pro Sec aufgerufen
        void CalcOneStep();  
};

class RectangleGen
{
    public:
        float val;  // momentaner Ausgangswert
    private:
        int _state;
        int _count;
        int _max;
    public:
        RectangleGen();
        
        
        void SetPointsPerPeriod(float aPoint);
        
        // bezogen auf   Fsample 0..0.5
        void SetFrequ(float aFrequ);
        
        //Einen Abtastwert berechnen
        // wird bei z.B. Fsample=100Hz 100x pro Sec aufgerufen
        void CalcOneStep();  
};

#endif