# include "FunkGen.h"

SignedRampGen::SignedRampGen()
{
    // sinnvolle Frequenz setzen
    SetPointsPerPeriod(50.0);
}

void SignedRampGen::SetPointsPerPeriod(float aPoints)
{
    _inc = 2.0/aPoints;
}

void SignedRampGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}

void SignedRampGen::CalcOneStep()
{
    val = val + _inc;
    if(val >1.0)
        val = -1 + (val - 1.0);
}


// TiangleGen

TriangleGen::TriangleGen()
{
    // sinnvolle Frequenz setzen
    SetPointsPerPeriod(50.0);
    _state = 1;
}

void TriangleGen::SetPointsPerPeriod(float aPoints)
{
    _inc = 4.0/aPoints;
}

void TriangleGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}

void TriangleGen::CalcOneStep()
{
    _phase = _phase + _inc;
    if(_phase > 1.0)
    {
        _phase = -1 + (_phase - 1.0);
        if(_state == 1)
            _state = 2;
            
        else
            _state = 1;
    }
        
    if(_state == 1)
        val = _phase;
        
    if(_state == 2)
        val = -_phase;
    
    
}

// RectangleGen

RectangleGen::RectangleGen()
{
    // sinnvolle Frequenz setzen
    SetPointsPerPeriod(50.0);
    _state = 1;
}

void RectangleGen::SetPointsPerPeriod(float aPoints)
{
    _max = aPoints;
}

void RectangleGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}

void RectangleGen::CalcOneStep()
{
    if(_count >= _max/2)
    {
        _count = 0;
        if(_state == 1)
            _state = 2;
            
        else
            _state = 1;
    }
    
    if(_state == 1)
    {
        _count++;
        val = 1;
    }
    
    else 
    {
        _count++;
        val = -1;
    } 
}

