#include "mbed.h"
#include "RTC.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"

#define USR_POWERDOWN    (0x104)
int semihost_powerdown() {
    uint32_t arg;
    return __semihost(USR_POWERDOWN, &arg);
}

 
DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);
 
int volatile count;
 
// Simon's Watchdog code from
// http://mbed.org/forum/mbed/topic/508/
class Watchdog {
public:
// Load timeout value in watchdog timer and enable //Register descriptions in the manual
    void kick(float s) {
        LPC_WDT->WDCLKSEL = 0x02;               // Set CLK src to RTC for DeepSleep wakeup; RTC runs on 32kHz
        LPC_WDT->WDTC = (s/4.0)*32768;          // Timeout value in 32bit register in terms of RTC ticks
        LPC_WDT->WDMOD = 0x3;                   // Enabled register(0) and Reset register(1)
        kick();
    }
// "kick" or "feed" the dog - reset the watchdog timer
// by writing this required bit pattern. If wrong sequence is used, a RESET is triggeered
    void kick() {
        LPC_WDT->WDFEED = 0xAA;
        LPC_WDT->WDFEED = 0x55;
    }
};
 
// Setup the watchdog timer
Watchdog wdt;
 
// Blink LED
void blink() {
    myled4 = 0;
    myled1 = 1;
}
Serial pc(USBTX, USBRX);
int main() {
    set_time(1256729737);
    //RTC::attach(&blink, RTC::Second);
    //Serial pc(USBTX, USBRX);
    int result;
    //Watchdog wdt;
    //pc.printf("Hello World!\n");
    
// On reset, determine if a watchdog, power on reset or a pushbutton caused reset and display on LED 4 or 3
// Check reset source register
    result = LPC_SC->RSID;
    if ((result & 0x03 )==0) {
// was not POR or reset pushbutton so
// Mbed is out of debug mode and reset so can enter DeepSleep now and wakeup using watchdog
        //myled4 = 1;
        wait(.0625);
        //wdt.kick(2);
        //blink();
        tm t = RTC::getDefaultTM();
        t.tm_sec = 5;
        RTC::alarm(&blink, t);
        DeepSleep();
        
        myled4 = 0;
// Watch dog timer wakes it up with a reset
//
    } else {
// Was an initial manual or Power on Reset
// This codes only executes the first time after initial POR or button reset
        LPC_SC->RSID = 0x0F;
// Clear reset source register bits for next reset
        myled3 = 1;
// LED3 on to indicate initial reset at full power level
// Normal mbed power level for this setup is around 690mW
// assuming 5V used on Vin pin
// Power down Ethernet interface - saves around 175mW -no cable as well
        PHY_PowerDown();
// Power down magic USB interface chip - saves around 150mW
// Needs new firmware (URL below) and Power need to be supplied from Vin pin not USB
// http://mbed.org/handbook/Beta

// Also exits debug mode - must not be in debug mode for deep power down modes (Board limitation)
        result = semihost_powerdown();
        
// Power consumption is now around half
// Turn off clock enables on unused I/O Peripherals (UARTs, Timers, PWM, SPI, CAN, I2C, A/D...)
// To save just a tiny bit more power - most are already off by default in this short code example
// See PowerControl.h for I/O device bit assignments
// Don't turn off GPIO - it is needed to blink the LEDs
        Peripheral_PowerDown(0xFFFF7FFF);
// Now can do a reset to free mbed of debug mode
// NXP manual says must exit debug mode and reset for DeepSleep or lower power levels to wakeup
        wait(1);
        NVIC_SystemReset();
    }
}