
#include "mbed.h"
#include "F746_GUI.hpp"
#include "CCLogo.h"

Serial Communication(PC_6, PC_7,115200); //Declaration serial
Timer timerEnvoieTrame; // Timer pour l'envoie de trame

int tailleBuffer=100; // timer pour l'envoie de trame

// fonction pour affichage de l'image 
void drawImage_CCLogo(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)CCLogo.data;
    while(y < CCLogo.height) {
        while(x < CCLogo.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//Recupère à quel emplacement il y a une valeur dans le buffer
int EmpDerVal(int *ptab){ 
    int Emplacement=-1;
  

    if(*ptab==-1) Emplacement=0;
    else{
        for(int i=2;i<=tailleBuffer*2;i=i+2){
            if(*(ptab+i)==-1){
                Emplacement=i/2;
                i=tailleBuffer*2+1;
            }
        }
    } 
 
    return Emplacement*2; // revoie l'emplacement *2 car tab 2 dimension
}

// Ajoute une valeur dans le buffer
void AppendTableau(int *ptab, int index, int data){
    int LastEmplacment=EmpDerVal((int*) ptab);
    
    *(ptab+LastEmplacment)=index;
    *(ptab+LastEmplacment+1)=data;
}

// Envoie une valeur 
void SendVal(int *ptab){
    int LastEmplacment=EmpDerVal((int*) ptab), index=-1, data=-1;
    if(LastEmplacment==0 || LastEmplacment==-1){
        //Buffer vide
    }
    else{ // buffer non vide
        index=*ptab; // l'ecture de l'index
        data=*(ptab+1); // l'ecture de la data
        Communication.putc(0xfb); //debut de la trame
        Communication.putc(index); // index
        Communication.putc(data); // data
        Communication.putc(0xfe); // fin de trame
        for(int i=0;i<LastEmplacment;i=i+2){ //actualisation du buffer
          *(ptab+i)=*(ptab+i+2);
          *(ptab+i+1)=*(ptab+i+3);
        }
    }
}


int main()
{
    // Variables d'état qui récupère le nombre du bouton appuyé pour switch cases
    int NumBoutonGroupMode=0, NumBoutonGroupeLeds=0; 
    
    int TabBuffer[tailleBuffer][2];
    int NivoBatt = 75,Vitesse=0, VitesseMax=25;

    
    //initialisation du buffer
    for(int i=0; i<tailleBuffer-1; i++) { 
        TabBuffer[i][0]=-1;
        TabBuffer[i][1]=-1;
    }
      
//////////////////////// Déclaration des groupes de boutons et mise en forme ////////////////////////
    Label Titre(240, 2, "Interface Trottinette", Label::CENTER, Font20); // titre

    SeekBar barVitesse(20, 230, 200, 0, 100, 0, "0", "Vitesse km/h",""); 
    NumericLabel<float> numLabeVitesse(90, 250, "%5.1f", barVitesse.GetValue(),Label::CENTER,Font12,0xFFFFFFFF, 0xFF000000);
    NumericLabel<int> ValMaxVitesse(220, 200, "%d", VitesseMax,Label::CENTER,Font12,0xFFFFFFFF, 0xFF000000);
    
    SeekBar barBatterie(260, 230, 200, 0, 100, 75, "0", "Niveau Batterie %", "100");
    NumericLabel<float> numLabelBatterie(340, 250, "%5.1f", barBatterie.GetValue(),Label::CENTER,Font12,0xFFFFFFFF, 0xFF000000);

    ButtonGroup boutonGroupeMode(300, 80, 66, 35,  4,(string[]) {
        "Sport", "Normal", "ECO", "Pieton"
    }, 2, 2, 2, 1,
    Font12, LCD_COLOR_WHITE, 0xFFFEAAAA, 0xFFFF0000, 0xFFFF0000);
    boutonGroupeMode.Inactivate(0);
    Label TitreMode(370, 60, "Mode", Label::CENTER, Font16);

    ButtonGroup boutonsGroupeLed(80, 80, 66, 35,  2,(string[]) {
        "ON", "OFF"
    }, 2, 2, 1, 1,
    Font12, LCD_COLOR_BLACK, 0xFFFE0000, 0xFFFFFF00, 0xFFFFFF00); 
    boutonsGroupeLed.Inactivate(0);
    Label TitreLeds(120, 60, "Lumiere", Label::CENTER, Font16);
    
    ButtonGroup boutonGroupeBatt(415, 5, 10, 5,  4,(string[]) {
        "", "", "", ""
    }, 2, 2, 4, 1,
    Font12);
    boutonGroupeBatt.InactivateAll();
//////////////////////////////////////////////////////////////////////////////////////////////////

    drawImage_CCLogo(0,0); // Appel de la fonction pour afficher l'image 
    
    timerEnvoieTrame.start();
    
    while(1) {
        
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK); // change le parametre de couleur du fond pour label

        if (barVitesse.Slide()) {
            numLabeVitesse.Draw("%5.1f", (barVitesse.GetValue()*VitesseMax)/100); //calcul val barslide a partir d'une bar sur 100
            Vitesse = (int) (barVitesse.GetValue()*VitesseMax)/100;
            AppendTableau(*TabBuffer,0x01,Vitesse);
        }
        
        if (barBatterie.Slide()) {
            numLabelBatterie.Draw("%5.1f", barBatterie.GetValue());
            NivoBatt = (int) barBatterie.GetValue();
            AppendTableau(*TabBuffer,0x02,NivoBatt);

            //Manipulation de la valeur du niveau de batterie
            if (NivoBatt < 25 && NivoBatt > 0){ // si batterie < 25%
                boutonGroupeBatt.Activate(0); // Affichage de la premiere barre 
                boutonGroupeBatt.Inactivate(1);
                boutonGroupeBatt.Inactivate(2);
                boutonGroupeBatt.Inactivate(3);
                boutonGroupeBatt.Draw(0, 0xFFFF0000, 0xFFFF0000); // Barre en couleur rouge

                
            }
            else if (NivoBatt < 50 && NivoBatt > 26){ // si env 50% batterie
                boutonGroupeBatt.Activate(0); // activer les deux premières barres
                boutonGroupeBatt.Activate(1);
                boutonGroupeBatt.Inactivate(2);
                boutonGroupeBatt.Inactivate(3);
                boutonGroupeBatt.Draw(0, 0xFFFFAA00, 0xFFFFAA00); // Barres en orange
                boutonGroupeBatt.Draw(1, 0xFFFFAA00, 0xFFFFAA00);
            } 
            
            else if (NivoBatt < 75 && NivoBatt > 51){ // Si env 75% batterie       
                boutonGroupeBatt.Activate(0); // activer 3 barres
                boutonGroupeBatt.Activate(1);
                boutonGroupeBatt.Activate(2);
                boutonGroupeBatt.Inactivate(3);
                boutonGroupeBatt.Draw(0, 0xFFFCFF00, 0xFFFCFF00); // Barres en jaune
                boutonGroupeBatt.Draw(1, 0xFFFCFF00, 0xFFFCFF00);
                boutonGroupeBatt.Draw(2, 0xFFFCFF00, 0xFFFCFF00);

                } 
            else if (NivoBatt > 76){ // si +75%
                boutonGroupeBatt.ActivateAll(); // Activer toutes les barres 
                boutonGroupeBatt.Draw(0, 0xFF47FF00, 0xFF47FF00); // Barres en vert
                boutonGroupeBatt.Draw(1, 0xFF47FF00, 0xFF47FF00);
                boutonGroupeBatt.Draw(2, 0xFF47FF00, 0xFF47FF00);
                boutonGroupeBatt.Draw(3, 0xFF47FF00, 0xFF47FF00);

            } 
            else if (NivoBatt < 0){ // Si plus de batterie 
                boutonGroupeBatt.InactivateAll(); // Ne pas afficher de barres
            }
        } 

        
        NumBoutonGroupMode=boutonGroupeMode.GetTouchedNumber(); //lecture de la valeur du bouton appuyé
        
        // Switch case en fonction du bouton appuyé pour selection du mode de la trottinette
        if (boutonGroupeMode.GetTouchedNumber(NumBoutonGroupMode))
            switch (NumBoutonGroupMode) {
                case 0: //mode Sport 25km/h Max
                    VitesseMax=25; // mise à jour de la vmax possible avec ce mode
                    boutonGroupeMode.Inactivate(0); // désactiver le bouton appuyé 
                    boutonGroupeMode.Activate(1); // Activer les autres boutons 
                    boutonGroupeMode.Activate(2);
                    boutonGroupeMode.Activate(3);
                    AppendTableau(*TabBuffer,0x03,0x01); // envoie de la trame liée à l'appuis de ce bouton
                    BSP_LCD_SetBackColor(LCD_COLOR_BLACK); 
                    
                    ValMaxVitesse.Draw("%d",VitesseMax); //recalcul de la vitesse à partir de l'emplacement curseur du slide
                    numLabeVitesse.Draw("%5.1f", (barVitesse.GetValue()*VitesseMax)/100);
                    Vitesse = (int) (barVitesse.GetValue()*VitesseMax)/100;
                    //AppendTableau(*TabBuffer,0x01,Vitesse);
                    break;
                    
                case 1: //mode Normal 20km/h Max
                    VitesseMax=20; // mise à jour de la vmax possible avec ce mode
                    boutonGroupeMode.Inactivate(1); // désactiver le bouton appuyé 
                    boutonGroupeMode.Activate(0); // Activer les autres boutons 
                    boutonGroupeMode.Activate(2);
                    boutonGroupeMode.Activate(3);
                    AppendTableau(*TabBuffer,0x03,0x02); // envoie de la trame liée à l'appuis de ce bouton
                    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
                    
                    ValMaxVitesse.Draw("%d",VitesseMax); //recalcul de la vitesse à partir de l'emplacement curseur du slide
                    numLabeVitesse.Draw("%5.1f", (barVitesse.GetValue()*VitesseMax)/100);
                    Vitesse = (int) (barVitesse.GetValue()*VitesseMax)/100;
                    //AppendTableau(*TabBuffer,0x01,Vitesse);
                    break;

                case 2: //mode Eco 15km/h Max
                    VitesseMax=15; // mise à jour de la vmax possible avec ce mode
                    boutonGroupeMode.Inactivate(2); // désactiver le bouton appuyé 
                    boutonGroupeMode.Activate(0); // Activer les autres boutons 
                    boutonGroupeMode.Activate(1);
                    boutonGroupeMode.Activate(3);
                    AppendTableau(*TabBuffer,0x03,0x03); // envoie de la trame liée à l'appuis de ce bouton
                    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
                    
                    ValMaxVitesse.Draw("%d",VitesseMax); //recalcul de la vitesse à partir de l'emplacement curseur du slide
                    numLabeVitesse.Draw("%5.1f", (barVitesse.GetValue()*VitesseMax)/100);
                    Vitesse = (int) (barVitesse.GetValue()*VitesseMax)/100;
                    //AppendTableau(*TabBuffer,0x01,Vitesse);
                    break;

                case 3: //mode Pieton 6km/h Max
                    VitesseMax=6; // mise à jour de la vmax possible avec ce mode
                    boutonGroupeMode.Inactivate(3); // désactiver le bouton appuyé 
                    boutonGroupeMode.Activate(0); // Activer les autres boutons 
                    boutonGroupeMode.Activate(1);
                    boutonGroupeMode.Activate(2);
                    AppendTableau(*TabBuffer,0x03,0x04); // envoie de la trame liée à l'appuis de ce bouton
                    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
                    
                    ValMaxVitesse.Draw("%d",VitesseMax); //recalcul de la vitesse à partir de l'emplacement curseur du slide
                    numLabeVitesse.Draw("%5.1f", (barVitesse.GetValue()*VitesseMax)/100);
                    Vitesse = (int) (barVitesse.GetValue()*VitesseMax)/100;
                    //AppendTableau(*TabBuffer,0x01,Vitesse);
                    break;

            }

        NumBoutonGroupeLeds=boutonsGroupeLed.GetTouchedNumber(); //lecture de la valeur du bouton appuyé
        
        // Switch case en fonction du bouton appuyé pour activation ou non Led trott
        if (boutonsGroupeLed.GetTouchedNumber(NumBoutonGroupeLeds))
            switch (NumBoutonGroupeLeds) {
                case 0: //Led ON
                    boutonsGroupeLed.Inactivate(0); // désactiver le bouton appuyé 
                    boutonsGroupeLed.Activate(1); // Activer les autres boutons 
                    AppendTableau(*TabBuffer,0x04,0x01); // envoie de la trame liée à l'appuis de ce bouton
                    break;

                case 1: //Led OFF
                    boutonsGroupeLed.Inactivate(1); // désactiver le bouton appuyé 
                    boutonsGroupeLed.Activate(0); // Activer les autres boutons 
                    AppendTableau(*TabBuffer,0x04,0x0F); // envoie de la trame liée à l'appuis de ce bouton
                    break;
            }


        if(timerEnvoieTrame.read()>0.01){ //Si timer envoie trame
            SendVal(*TabBuffer); //envoie du buffer pour check si il y a valeur a envoier
            timerEnvoieTrame.reset(); // reset du timer
        }

    }
}

