
#include "mbed.h"
#include "F746_GUI.hpp"

DigitalOut dirPin(D2); // pin de direction défini sur D2 
DigitalOut stepPin(D3); // pin de pas défini sur D3 

int main()
{
    // init variables lisant les valeurs de quel bouton est appuyé dans chaque groupe
    int etat = 0, NumBoutonGrpRotation=-1, NumBoutonGrpVitesse=-1, NumBoutonGrpPlay=-1;
    
    // Titre
    Label Titre(240, 10, "", Label::CENTER, Font20);

////// Init des groupes de boutons //////  
    
    // Groupe de bouton du sens de rotation (2 boutons)
    Label Rotation(240, 40, "Sens de rotation", Label::CENTER, Font16);
    ButtonGroup GrpRotation(145, 60, 90, 35, 2,(string[]) {
        "Horaire", "Anti-Horaire"
    }, 2, 2, 2, 1,
    Font12, LCD_COLOR_WHITE, 0xFFFEAAAA, 0xFFFF0000, 0xFFFF0000);
    GrpRotation.ActivateAll(); // activation de tous les boutons
    
    // Groupe de bouton de la vitesse de rotation (3 boutons)    
    Label TitreVitesse(240, 120, "Vitesse de rotation", Label::CENTER, Font16);
    ButtonGroup GrpVitesse(100, 140, 90, 35, 3,(string[]) {
        "650", "650-800", "800"
    }, 2, 2, 3, 1,
    Font12, LCD_COLOR_BLACK, 0xFFFE0000, 0xFFFFFF00, 0xFFFFFF00);
    GrpVitesse.InactivateAll();// désactivation de tous les boutons
    
    // Bouton Stop 
    Button BTStop(215, 200, 50, 35, "Stop",
    Font12, LCD_COLOR_BLACK, 0xFFFE0000, 0xFFFFFF00, 0xFFFFFF00);
    BTStop.Inactivate();// désactivation du bouton


    while(1) {
        BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
        
        // lecture du numéro du bouton appuyé
        NumBoutonGrpRotation=GrpRotation.GetTouchedNumber();
        NumBoutonGrpVitesse=GrpVitesse.GetTouchedNumber();

        switch(etat) {

            case 0: //initialisation générale
                GrpVitesse.InactivateAll(); // désactivation du choix de la vitesse 
                if (NumBoutonGrpRotation == 0) etat = 1; // si bouton 0 appuyé (horaire), go to case 1
                else if (NumBoutonGrpRotation == 1) etat = 2; // si bouton 1 appuyé (antihoraire), go to case 2
                break;

            case 1: // sens Horaire
                GrpVitesse.ActivateAll(); // activation des boutons pour choix de la vitesse
                GrpRotation.Inactivate(0); // désactivation du bouton choisi
                dirPin = 1; // définition du sens de rotation en sens horaire
                etat = 3; // go to case 3 pour choix de la vitesse
                break;

            case 2: // sens Anti horaire
                GrpVitesse.ActivateAll(); // activation des boutons pour choix de la vitesse
                GrpRotation.Inactivate(1); // désactivation du bouton choisi
                dirPin = 0; // définition du sens de rotation en sens antihoraire
                etat = 3; // go to case 3 pour choix de la vitesse
                break;

            case 3: // choix vitesse selon le bouton appuyé
                if (NumBoutonGrpVitesse == 0) etat = 4; //si bouton 0 appuyé (650) go to case 4
                else if (NumBoutonGrpVitesse == 1) etat = 5; //si bouton 1 appuyé (650-800) go to case 5
                else if (NumBoutonGrpVitesse == 2) etat = 6; //si bouton 0 appuyé (800) go to case 6
                break;

            case 4: // 650 TPD
                //3 step par seconde
                GrpVitesse.InactivateAll(); // désactivation choix de la vitesse
                GrpRotation.InactivateAll(); // désactivation choix du sens de rotation 
                BTStop.Activate(); // activation du bouton stop 

                // lancement du cycle de rotation du remontoir
                for(int nb_tour=0; nb_tour < 86400; nb_tour++){ // nb de seconde par jour
                    for(int x = 0; x < 3; x++){ //3 step par seconde
                        stepPin=1;
                        wait_ms(166); // ce qui définit la vitesse de 650 TPD
                        stepPin=0;
                        wait_ms(166); // ce qui définit la vitesse de 650 TPD
                        
                        if(BTStop.Touched()==1){ // si bouton stop appuyé
                            x=4; // stop du 2e for
                            nb_tour = 86401; // stop du 1er for
                            GrpRotation.ActivateAll(); // réactivation choix sens de rotation 
                            BTStop.Inactivate(); // désactivation du bouton stop car plus besoin à l'init
                            etat = 0; // go to case init                        
                        }
                    }
                    etat = 0; // si le cycle est fini, go to case init
                }
                break;

            case 5: //650-800
                //3 step par seconde
                GrpVitesse.InactivateAll(); // désactivation choix de la vitesse
                GrpRotation.InactivateAll(); // désactivation choix du sens de rotation 
                BTStop.Activate(); // activation du bouton stop 

                // lancement du cycle de rotation du remontoir
                for(int nb_tour=0; nb_tour < 43200; nb_tour++){ // nb de seconde par jour
                    for(int x = 0; x < 3; x++){ //3 step par seconde
                        stepPin=1;
                        wait_ms(166);
                        stepPin=0;
                        wait_ms(166);
                        if(BTStop.Touched()==1){ // si bouton stop appuyé
                            x=4; // stop du 2e for
                            nb_tour = 86401; // stop du 1er for
                            GrpRotation.ActivateAll(); // réactivation choix sens de rotation 
                            BTStop.Inactivate(); // désactivation du bouton stop car plus besoin à l'init
                            etat = 0; // go to case init                        
                        }
                    }
                    
                    for(int nb_tour=0; nb_tour < 43200; nb_tour++){ // nb de seconde par jour
                        for(int x = 0; x < 3; x++){ //3 step par seconde
                            stepPin=1;
                            wait_ms(135);
                            stepPin=0;
                            wait_ms(135);
                            if(BTStop.Touched()==1){ // si bouton stop appuyé
                                x=4; // stop du 2e for
                                nb_tour = 86401; // stop du 1er for
                                GrpRotation.ActivateAll(); // réactivation choix sens de rotation 
                                BTStop.Inactivate(); // désactivation du bouton stop car plus besoin à l'init
                                etat = 0; // go to case init                        
                            }
                        }
                    etat = 0; // si le cycle est fini, go to case init
                }
                break;

            case 6: //800
                //3 step par seconde
                GrpVitesse.InactivateAll(); // désactivation choix de la vitesse
                GrpRotation.InactivateAll(); // désactivation choix du sens de rotation 
                BTStop.Activate(); // activation du bouton stop 

                // lancement du cycle de rotation du remontoir
                for(int nb_tour=0; nb_tour < 86400; nb_tour++){ // nb de seconde par jour
                    for(int x = 0; x < 3; x++){ //3 step par seconde
                        stepPin=1;
                        wait_ms(135); // ce qui définit la vitesse de 800 TPD
                        stepPin=0;
                        wait_ms(135); // ce qui définit la vitesse de 800 TPD
                        
                        if(BTStop.Touched()==1){ // si bouton stop appuyé
                            x=4; // stop du 2e for
                            nb_tour = 86401; // stop du 1er for
                            GrpRotation.ActivateAll(); // réactivation choix sens de rotation 
                            BTStop.Inactivate(); // désactivation du bouton stop car plus besoin à l'init
                            etat = 0; // go to case init                        
                        }
                    }
                    etat = 0; // si le cycle est fini, go to case init
                }
                break;
        }
        }

    } //while
} //main
