#include "player.h"
#include"SDFileSystem.h"
#include<string.h>

SDFileSystem sd(D11, D12, D13, D9, "sd"); // the pinout on the mbed Cool
vs10xx vs1053(D11, D12, D13, D6, D7, D2, D8);//mosi,miso,sclk,xcs,xdcs,dreq,xreset
Serial pc(USBTX, USBRX);
playerStatetype  playerState;
ctrlStatetype ctrlState;
char list[20][14];            //song list
static unsigned char fileBuf[1024];
unsigned char *bufptr;



void Player::begin(void)
{
    DirHandle *dir;
    struct dirent *ptr;
		FileHandle *fp;
   
    vs1053.reset();
    dir = opendir("/sd");
    printf("\r\n**********playing list**********\r\n");
    unsigned char i = 0,j=0;
    while(((ptr = dir->readdir()) != NULL)&&(i <20)) {
        if(strstr(ptr->d_name,".mp3")||strstr(ptr->d_name,".MP3")) {
            fp =sd.open(ptr->d_name, O_RDONLY);
            if(fp != NULL) {
                char *byte = ptr->d_name;
                j=0;
                while(*byte) {
                    list[i][j++]  = *byte++;
                }
                printf("%2d . %s\r\n", i+1,list[i++]);
                fp->close();
            }
        }
    }
    //index_MAX = i-1;
		dir->closedir();
    printf("\r\n");
}



/*  This function plays back an audio file.  */
void Player::playFile(char *file){
    int bytes;        // How many bytes in buffer left
    char n;

    playerState = PS_PLAY;
    vs1053.setFreq(24000000);     //hight speed
	
    FileHandle *fp =sd.open(file, O_RDONLY);
    if(fp == NULL){
        printf("Could not open %s\r\n",file);

    }else{
        printf("Playing %s ...\r\n",file);

        /* Main playback loop */
         while((bytes = fp->read(fileBuf,512)) > 0) {
            bufptr = fileBuf;
            // actual audio data gets sent to VS10xx.
            //pc.printf("now: playing\n");
            while(bytes > 0) {
                n = (bytes < 32)?bytes:32;
                vs1053.writeData(bufptr,n);
                bytes -= n;
                bufptr += n;
                if(playerState == PS_STOP) break;
				//pc.printf("now: bype>0\n");
            }
            if(playerState == PS_STOP) break;
        }
        fp->close();
        vs1053.softReset();
        printf("[done!]\r\n");
    }
}


