#include "mbed.h"
Timer timer1;
Timer timer2;
DigitalOut doLed1(LED1);
DigitalOut doLed2(LED2);
bool activTimer1 = true;
InterruptIn stopNgo(p15);

// functions
void task1() {
    doLed1 = !doLed1;
}
void task2() {
    doLed2 = !doLed2;
}
void sgLed1() {
    if (activTimer1)
        timer1.stop();
    else 
        timer1.start();
    activTimer1 = !activTimer1;
}

int main() {
    timer1.start(); // start timer1 counting 
    timer2.start(); // start timer2 counting 
    stopNgo.rise(&sgLed1);
    while(1) { 
        if (timer1.read_ms()>=200) { // read time  
            task1(); // call task1 function 
            timer1.reset(); // reset timer 
        } 
        if (timer2.read_ms()>=700) { // read time  
            task2(); // call task2 function 
            timer2.reset(); // reset timer 
        } 
    } 
}