#include "mbed.h"
Timer timer1;
Timer timer2;
DigitalOut doLed1(LED1);
DigitalOut doLed2(LED2);
DigitalOut doLed3(LED3);
bool activTimer1 = true;
InterruptIn stopNgo(p15);
Timeout toT2Off;
InterruptIn inRestartT2(p12);
InterruptIn inT2TimoutDetach(p14);
Ticker ticToogleL3;
Ticker ticRGB;
BusOut RGB(p23, p24, p25);
int color = 0;

// functions
void task1() {
    doLed1 = !doLed1;
}
void task2() {
    doLed2 = !doLed2;
}
void sgLed1() {
    if (activTimer1)
        timer1.stop();
    else 
        timer1.start();
    activTimer1 = !activTimer1;
}

void T2Off() {
    timer2.stop();        
}

void T2On() {
    timer2.start();   
    toT2Off.attach(&T2Off, 5.0);
}

void T2TimoutDetach() {
    toT2Off.detach();
    timer2.start();
}

void toogleL3() {
    doLed3 = !doLed3;    
}

void RGBmix() {
      RGB = color;
      color = (color+1)%7;   
}


int main() {
    timer1.start(); // start timer1 counting 
    timer2.start(); // start timer2 counting 
    stopNgo.rise(&sgLed1);
    toT2Off.attach(&T2Off, 10.0);
    inRestartT2.fall(&T2On);
    inT2TimoutDetach.fall(&T2TimoutDetach);
    ticToogleL3.attach_us(&toogleL3, 100*1000); // 100 msec
    ticRGB.attach(&RGBmix, 0.25);
    
    while(1) { 
        if (timer1.read_ms()>=200) { // read time  
            task1(); // call task1 function 
            timer1.reset(); // reset timer 
        } 
        if (timer2.read_ms()>=700) { // read time  
            task2(); // call task2 function 
            timer2.reset(); // reset timer 
        } 
    } 
}