/* 
Serial Communication with a PC
The mbed Microcontroller can communicate with a host PC through a "USB Virtual Serial Port" 
over the same USB cable that is used for programming.
This enables you to:
a) Print out messages to a host PC terminal (useful for debugging!)
b) Read input from the host PC keyboard
c) Communicate with applications and programming languages running on the host PC 
   that can communicate with a serial port, e.g. perl, python, java, c# and so on.
.. see http://mbed.org/handbook/SerialPC 

The C stdin, stdout and stderr file handles are also defaulted to the PC serial connection
standard calls are: printf, scanf, getc, putc, ..
*/

#include "mbed.h"
// global vars and objects
DigitalOut led2(LED2);
Serial pc(USBTX, USBRX); // tx, rx    ; is default !!! (9600, 8N1)

// functions
void flushSerialBuffer() { 
    while (pc.readable()) { 
        pc.getc(); 
    } 
}
    
int main() {
    //pc.baud(115200);
    pc.baud(38400);
    pc.format(8, SerialBase::Odd,2);
    led2 = 1;
    char recChar=0, waitOnKey=1; 
    flushSerialBuffer();
    pc.printf("Hello RS232-USB Virtual Serial Port -World!\r\n");
    
    while(1) {
        if (pc.readable()) {
            recChar = pc.getc();
            pc.printf("That's the input: %c\r\n", recChar);  
            waitOnKey = 1;
            led2 = !led2;
        }
        else {
            if (waitOnKey) {
                pc.printf(".. press a key!\r\n"); 
                waitOnKey = 0;
                led2 = 0;
            }          
        }
    }
}
