/*******************************************************
Nom ......... : main.cpp
Role ........ : Récupération de données, mises en forme, 
                des capteurs de :
                Luminosité, Température de l'air, 
                Humidité de l'air, Température du sol 
                et Huminidité du sol.
                Affichage dans la console et sur l'écran
                OLED, envoie sur le site 
                ACTOBOARD via module Sigfox. 
Auteur ...... : GEORGE Pierre, LOUVION Quentin et 
                FAISANT Pierre-Yves
Version ..... : V0 du 17/10/2017
********************************************************/

#include "mbed.h"
#include "OneWire.h"
#include "TSL2561.h"
#include "DHT22.h"
#include "ssd1306.h"
#include "standard_font.h"
#include "bold_font.h"

//Déclaration variables
TSL2561 Lum(PB_7,PB_6,0x39); // Luminosité (I2C:SDA,SCL)
DHT22 Tem_Hum_A(PA_11); // Température & Humidité air
OneWire Tem_S(PA_8); // Température sol
AnalogIn Hum_S(PA_0); // Huminidité sol
Serial pc(PA_2,PA_3); //Serial : Tx,Rx
SSD1306 oled(PB_0,PB_4,PB_5,PA_5,PA_7); // OLED : CS,Reset,DC,Clock,Data
Serial sigfox(PA_9,PA_10,9600); // Module Sigfox
LowPowerTicker t1; // Ticker pour la fonction d'interruption

DigitalIn btn(D6);//button
InterruptIn button(D6);




char _id[16];
DeviceAddresses* devAddresses;
uint8_t foundNum;

volatile uint8_t flag=1,flag_screen=0;

void run() 
{
    I2C i2c(PB_7,PB_6);
        Lum.power_up();
    //OneWire Tem_S
    wait_ms(400);
    OneWireDeviceTemperature::startConversationForAll(&Tem_S, OWTEMP_11_BIT);
    for (uint8_t i = 0; i < foundNum; i++) 
    {
        OneWireDevice* owDevice = OneWireDeviceFactory::init(&Tem_S, (*devAddresses)[i]);
        
        if (owDevice->getFamily() != ONEWIRE_DS18B20_FAMILY)    // currently only DS18B20 supports
            continue;

        owDevice->generateId(_id);
        
        Tem_Hum_A.sample();

        // Calcul sur les données envoyées par les capteurs
        float Lumux = Lum.lux();
        float Temp_Air = Tem_Hum_A.getTemperature()/10.0;
        float Hum_Air = Tem_Hum_A.getHumidity()/10.0;
        float Temp_Sol = owDevice->sendGetCommand(GET_TEMPERATURE);
        float Hum_Sol = Hum_S.read();
        
        // Affichage données, mises en forme, sur la console
        printf( "Lum: %.2f \tTemp_A: %.2f \tHum_A: %.2f \tTemp_S: %.2f \tHum_S: %.2f\r\n", Lumux, Temp_Air, Hum_Air, Temp_Sol, Hum_Sol);
        
        // Envoie données, mises en forme, sur ACTOBOARD
        sigfox.printf("AT$SF=");
        sigfox.printf("%02x%02x%02x%02x%02x",(int)Lumux,(int)Temp_Air,(int)Hum_Air,(int)Temp_Sol,(int)Hum_Sol);
        sigfox.printf("\n\r");
        
        delete owDevice;   
         
        SPI spi(PA_7,NC, PA_5);
        
        // Affichage données, mises en forme, sur l'écran OLED
        wait(2);
        
        Lum.power_down();
    }
}
void interruption(){
    flag=1;
    }
void int_screen()
{
    flag_screen = 1;    
}
void screen()
{
    oled.initialise();
    oled.clear();
    oled.set_contrast(255); // max contrast
 
    oled.set_font(bold_font, 8);
    I2C i2c(PB_7,PB_6);
        Lum.power_up();
    //OneWire Tem_S
    wait_ms(600);
    OneWireDeviceTemperature::startConversationForAll(&Tem_S, OWTEMP_11_BIT);
    for (uint8_t i = 0; i < foundNum; i++) 
    {
        OneWireDevice* owDevice = OneWireDeviceFactory::init(&Tem_S, (*devAddresses)[i]);
        
        if (owDevice->getFamily() != ONEWIRE_DS18B20_FAMILY)    // currently only DS18B20 supports
            continue;

        owDevice->generateId(_id);
        
        Tem_Hum_A.sample();

        // Calcul sur les données envoyées par les capteurs
        float Lumux = Lum.lux();
        float Temp_Air = Tem_Hum_A.getTemperature()/10.0;
        float Hum_Air = Tem_Hum_A.getHumidity()/10.0;
        float Temp_Sol = owDevice->sendGetCommand(GET_TEMPERATURE);
        float Hum_Sol = Hum_S.read();
        
       
        

        
        delete owDevice;   
         
        SPI spi(PA_7,NC, PA_5);
        
        // Affichage données, mises en forme, sur l'écran OLED
        wait(2);
        printf( "Lum: %.2f \tTemp_A: %.2f \tHum_A: %.2f \tTemp_S: %.2f \tHum_S: %.2f\r\n", Lumux, Temp_Air, Hum_Air, Temp_Sol, Hum_Sol);
        oled.set_font(bold_font, 8);
        oled.printf("Capteurs\r\n");
        oled.printf("\r\n");
        oled.set_font(standard_font, 6);
        oled.printf("Lum: %.2f\r\n", Lumux);    
        oled.printf("Temp_A: %.2f\r\n", Temp_Air);
        oled.printf("Hum_A: %.2f\r\n", Hum_Air);
        oled.printf("Temp_S: %.2f\r\n",Temp_Sol);
        oled.printf("Hum_S: %.2f\r\n", Hum_Sol);
        oled.printf("\r\n");
        oled.update();
        Lum.power_down();
    }
    wait(5);
    oled.off();
   
        
}
int main() {
    //OneWire Tem_S
    I2C i2c(PB_7,PB_6);
    devAddresses = Tem_S.getFoundDevAddresses();
    foundNum = Tem_S.getFoundDevNum();
    
    SPI spi(PA_7,NC, PA_5);
    
    //OLED
    oled.initialise();
    oled.clear();
    oled.set_contrast(255); // max contrast
 
    oled.set_font(bold_font, 8);
    oled.printf("Heading\r\n");
 
    oled.set_font(standard_font, 6);
    oled.printf("Hello World!\r\n");
    oled.printf("Some more text here..");

    oled.update();
    
    //t1.attach(interruption,61);
    t1.attach(interruption,5);
    btn.mode(PullUp);
    button.rise(&int_screen);  // attach the address of screen
    //run();
    while(1) 
    {
        if(flag)
        {
            run();
            flag=0;
        }
        else if(flag_screen)
        {
            screen();
            flag_screen=0;
        }
        deepsleep();
    }
}
