/* mBed FB6612FNG Library 
 *
 * onerous copyright here
 */

#ifndef MBED_TB6612FNG_H
#define MBED_TB6612FNG_H

#include "mbed.h"

/** 
 *
 */
class TB6612FNG {
    private:
        PwmOut motorPWM;
        DigitalOut In1;
        DigitalOut In2; 
    public:
    
        /** Creates a TB6612FNG object connected to the mbed.
         * Note that for a full TB6612FNG 2 objects will need to be declaired and a DigitalOut to control the standby pin.
         * @param pPWM
         * @param pIn1
         * @param pIn2
         */
        TB6612FNG(PinName pPWM, PinName pIn1, PinName pIn2);       
        
        /** Setting the speed
         * @param newSpeed The new speed in the range -1.0 to +1.0
         */
        void setSpeed(float newSpeed);        
        
        /** Reading the speed
         * @returns The speed in the range -1.0 to +1.0
         */
        float getSpeed(void);
        
        /** Shorthand for the setSpeed and getSpeed functions */
        void operator= (float param);        
        operator float();        
};

#endif