#include "TB6612FNG.h"
#include "mbed.h"

TB6612FNG::TB6612FNG(PinName pPWM, PinName pIn1, PinName pIn2): motorPWM(pPWM), In1(pIn1), In2(pIn2) {
    motorPWM = 0;
    motorPWM.period(0.001);
    In1 = 0;
    In2 = 0;     
}

void TB6612FNG::setSpeed(float newSpeed) {
    if(newSpeed > 0) {
        In1 = 0;
        In2 = 1;
        motorPWM = newSpeed;
    }
    else if(newSpeed < 0) {
        In1 = 1;
        In2 = 0;
        motorPWM = newSpeed * -1;
    }
    else {
        In1 = 1;
        In2 = 1;
        motorPWM = 0;
    }
}

float TB6612FNG::getSpeed(void) {
    if(In2 == 0) return motorPWM * -1;
    else return motorPWM;
}

void TB6612FNG::operator= (float param) {
    setSpeed(param);
}

TB6612FNG::operator float() {
    return getSpeed();
    // be nice if this operated for print statements
}
        
