




#ifndef MBED_PAW3102DB_H
#define MBED_PAW3102DB_H

#include "mbed.h"

/* Register Aliases */
#define CONFIGURATION 0x1B
#define OPERATION_MODE2 0x1A
#define IMAGE_QUALITY2 0x19
#define DELTA_Y2 0x18
#define DELTA_X2 0x17
#define MOTION_STATUS 0x16
#define PRODUCT_ID3 0x15
#define PRODUCT_ID2 0x14
#define WRITE_PROTECT 0x12
#define IMAGE_QUALITY 0x04
#define DELTA_X 0x03
#define DELTA_Y 0x02
#define PRODUCT_ID1 0x01
#define OPERATION_MODE1 0x00

class PAW3102DB {
    private:
        SPIHalfDuplex sensor;
        PinName MOSI;
        PinName MISO;
        PinName SCK;
        
    public:
        PAW3102DB(PinName pMOSI, PinName pMISO, PinName pSCK);
        unsigned char read(unsigned char address);
        
        signed char getDeltaX(void);
        signed char getDeltaY(void);
        
        unsigned short getProductID(void);
        unsigned short getResolution(void);

};

#endif