#include "PAW3102DB.h"
#include "mbed.h"

PAW3102DB::PAW3102DB(PinName pMOSI, PinName pMISO, PinName pSCK): sensor(pMOSI, pMISO, pSCK) {
    MOSI = pMOSI;
    MISO = pMISO;
    SCK = pSCK;
    
    sensor.frequency(10000000); // set it to 10MHz
    sensor.format(8, 3); // send 8 bits, change on falling, read on rising
    sensor.slave_format(8); // 8 bits returned
}

unsigned char PAW3102DB::read(unsigned char address) {
    return (char)sensor.write(address & 0x7F);
}

unsigned short PAW3102DB::getProductID(void) {
    return (sensor.write(PRODUCT_ID2) << 4) | (sensor.write(PRODUCT_ID3) >> 4);
}

unsigned short PAW3102DB::getResolution(void) {
    unsigned short resolution = 0;
    unsigned char buffer = sensor.write(MOTION_STATUS);
    buffer = (buffer >> 4) & 0x03;
    switch (buffer)
    {
        case 0:
            resolution = 1000;
            break;
        case 1:
            resolution = 1200;
            break;
        case 2:
            resolution = 1600;
            break;
        case 3:
            resolution = 800;
            break;
        default:
            break;    
    }
    return resolution;
}

signed char PAW3102DB::getDeltaX(void) {
    signed char buffer = read(DELTA_X);
    buffer *= -1; // dirty hack
    return buffer;     
}
signed char PAW3102DB::getDeltaY(void) {
    signed char buffer = read(DELTA_Y);
    buffer *= -1; // dirty hack
    return buffer;   
}    
