#ifndef MBED_LEES_ALGORITHM_H
#define MBED_LEES_ALGORITHM_H

#include "mbed.h"

struct _location {
        unsigned char x;
        unsigned char y;
};

class Lees_Algorithm {
private:
    // cell structure
    struct _cell {
        bool north;
        bool west;
        unsigned char weight;
    } **map; //array of the maze

    unsigned char mazeSize;
    unsigned char maxWeight;
    
    _location stack[300];
    unsigned char nextRead, nextWrite, stackSize;
    
    void push(_location newLoc) {
        stackSize ++;
        stack[nextWrite] = newLoc;
        nextWrite = (nextWrite + 1) % 300;
    }
    
    _location pull(void) {
        stackSize --;
        _location buffer = stack[nextRead];
        nextRead = (nextRead + 1) % 300;
        return buffer;
    }
    
    

    // stack
public:

    Lees_Algorithm(unsigned char size_);
    ~Lees_Algorithm(void);

    void updateMap(_location position, bool north, bool west, bool south, bool east);
    char getDirection(_location position, char facing); // returns a letter describing direction
    void printMaze(Serial output);
    void setDestination(_location target);
    void clearWeights(void); // for the entire maze
    void initialFill(void);

};

#endif