#include "mbed.h"
#include "LCD4884.h"
#include "MFRC522.h"

#define MF_RESET    D8
#define SPI_CS      D10

int ReadRFID_forLCD();

//LCD
AnalogIn analog_button_select(A0);
AnalogIn analog_button_press(A1);
AnalogIn analog_button_alarm(A2);
LCD4884 p;
//Serial pc(D1 , D0);

//RFID
DigitalOut LedGreen(LED1);
Serial pc(SERIAL_TX, SERIAL_RX);
MFRC522    RfChip   (PC_12, PC_11, PC_10, SPI_CS, MF_RESET);

int main()
{
    p.LCD_init();
    p.LCD_write_string(28,2,"Hello",MENU_NORMAL);
    uint8_t state = 0;
    double select, press;
    int line, rfid_ID;

    int row1 = 2;
    int row2 = 72;
    int row3 = 142;
    int row4 = 212;
    int row5 = 282;

    float sensor[60] = {7,0,0,0,0,0,0,0,0,14,                                  //sensor input for graph
                        0,0,0,0,0,0,0,0,0,21,
                        0,0,0,0,0,0,0,0,0,28,
                        0,0,0,0,0,0,0,0,0,35,
                        0,0,0,0,0,0,0,0,0,42,
                        0,0,0,0,0,0,0,0,0,49
                       };

    unsigned char img[] = {                                                     //graph
        128,255,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

        128,255,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

        128,255,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

        128,255,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

        128,255,128,128,128,128,128,128,128,128,128,192,128,128,
        128,128,128,128,128,128,128,192,128,128,128,128,128,128,
        128,128,128,192,128,128,128,128,128,128,128,128,128,192,
        128,128,128,128,128,128,128,128,128,192,128,128,128,128,
        128,128,128,128,128,192,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
    };

    while(1) {

        select = analog_button_select.read();
        press = analog_button_press.read();

        printf("Program started\n");

        int n = 0;
        while (n != 60) {
            //Start Row5
            if (sensor[n] == 1) {
                img[row5+n] = 128;
            } else if (sensor[n] == 2) {
                img[row5+n] = 192;
            } else if (sensor[n] == 3) {
                img[row5+n] = 160;
            } else if (sensor[n] == 4) {
                img[row5+n] = 144;
            } else if (sensor[n] == 5) {
                img[row5+n] = 144;
            } else if (sensor[n] == 6) {
                img[row5+n] = 136;
            } else if (sensor[n] == 7) {
                img[row5+n] = 136;
            } else if (sensor[n] == 8) {
                img[row5+n] = 132;
            } else if (sensor[n] == 9) {
                img[row5+n] = 132;
            } else if (sensor[n] == 10) {
                img[row5+n] = 129;
            }
            //End Row5

            //Start Row4
            if (sensor[n] == 11) {
                img[row4+n] = 128;
            } else if (sensor[n] == 12) {
                img[row4+n] = 64;
            } else if (sensor[n] == 13) {
                img[row4+n] = 32;
            } else if (sensor[n] == 14) {
                img[row4+n] = 16;
            } else if (sensor[n] == 15) {
                img[row4+n] = 16;
            } else if (sensor[n] == 16) {
                img[row4+n] = 8;
            } else if (sensor[n] == 17) {
                img[row4+n] = 8;
            } else if (sensor[n] == 18) {
                img[row4+n] = 4;
            } else if (sensor[n] == 19) {
                img[row4+n] = 2;
            } else if (sensor[n] == 20) {
                img[row4+n] = 1;
            }
            //End Row4

            //Start Row3
            if (sensor[n] == 21) {
                img[row3+n] = 128;
            } else if (sensor[n] == 22) {
                img[row3+n] = 64;
            } else if (sensor[n] == 23) {
                img[row3+n] = 32;
            } else if (sensor[n] == 24) {
                img[row3+n] = 16;
            } else if (sensor[n] == 25) {
                img[row3+n] = 16;
            } else if (sensor[n] == 26) {
                img[row3+n] = 8;
            } else if (sensor[n] == 27) {
                img[row3+n] = 8;
            } else if (sensor[n] == 28) {
                img[row3+n] = 4;
            } else if (sensor[n] == 29) {
                img[row3+n] = 2;
            } else if (sensor[n] == 30) {
                img[row3+n] = 1;
            }
            //End Row3

            //Start Row2
            if (sensor[n] == 31) {
                img[row2+n] = 128;
            } else if (sensor[n] == 32) {
                img[row2+n] = 64;
            } else if (sensor[n] == 33) {
                img[row2+n] = 32;
            } else if (sensor[n] == 34) {
                img[row2+n] = 16;
            } else if (sensor[n] == 35) {
                img[row2+n] = 16;
            } else if (sensor[n] == 36) {
                img[row2+n] = 8;
            } else if (sensor[n] == 37) {
                img[row2+n] = 8;
            } else if (sensor[n] == 38) {
                img[row2+n] = 4;
            } else if (sensor[n] == 39) {
                img[row2+n] = 2;
            } else if (sensor[n] == 40) {
                img[row2+n] = 1;
            }
            //End Row2

            //Start Row1
            if (sensor[n] == 41) {
                img[row1+n] = 128;
            } else if (sensor[n] == 42) {
                img[row1+n] = 64;
            } else if (sensor[n] == 43) {
                img[row1+n] = 32;
            } else if (sensor[n] == 44) {
                img[row1+n] = 16;
            } else if (sensor[n] == 45) {
                img[row1+n] = 16;
            } else if (sensor[n] == 46) {
                img[row1+n] = 8;
            } else if (sensor[n] == 47) {
                img[row1+n] = 8;
            } else if (sensor[n] == 48) {
                img[row1+n] = 4;
            } else if (sensor[n] == 49) {
                img[row1+n] = 2;
            } else if (sensor[n] == 50) {
                img[row1+n] = 1;
            }
            //End Row1
            n = n +1;
        }

        if (state == 0) {                                                       // Home Page
            p.backlight(0);
            p.LCD_write_string(28,2,"Hello",MENU_NORMAL);
            printf("I am in home page\n");

            rfid_ID = ReadRFID_forLCD();
            //printf("ID = %d\n",rfid_ID);

            if (rfid_ID == 0) {
                printf("Admin detected\n");
                p.LCD_clear();
                state = 1;
            }

            else if (rfid_ID == 1) {
                printf("Alarm detected\n");
                p.LCD_clear();
                state = 2;
            }
        }

        /*           if (ss_analysis == 0) {                    // Alarm Page
                       printf("Alarm detected");
                       p.LCD_clear();
                       state = 2;
                   } else {
                       if (rfid_ID == 0) {
                           printf("Admin detected");
                           p.LCD_clear();
                           state = 1;
                       } else break;
                   }
        */


        else if (state == 1) {                                                  //Admin Page
            p.backlight(1);
            p.LCD_write_string(25,0,"Admin",MENU_HIGHLIGHT);
            p.LCD_write_string(0,1,"- Motion Graph",MENU_NORMAL);
            p.LCD_write_string(0,2,"- AC Graph",MENU_NORMAL);
            p.LCD_write_string(0,3,"- LDR Graph",MENU_NORMAL);
            p.LCD_write_string(0,4,"Back",MENU_NORMAL);


            while(1) {
                select = analog_button_select.read();
                press = analog_button_press.read();

                if (select != 0 && press != 0) {                                // no press
                    if (line == 1) {
                        p.LCD_write_string(25,0,"Admin",MENU_NORMAL);
                        p.LCD_write_string(0,1,"- Motion Graph",MENU_HIGHLIGHT);    //line = 0
                        p.LCD_write_string(0,2,"- AC Graph",MENU_NORMAL);
                        p.LCD_write_string(0,3,"- LDR Graph",MENU_NORMAL);
                        p.LCD_write_string(0,4,"Back",MENU_NORMAL);
                    }

                    else if (line == 2) {
                        p.LCD_write_string(25,0,"Admin",MENU_NORMAL);
                        p.LCD_write_string(0,1,"- Motion Graph",MENU_NORMAL);
                        p.LCD_write_string(0,2,"- AC Graph",MENU_HIGHLIGHT);        //line = 1
                        p.LCD_write_string(0,3,"- LDR Graph",MENU_NORMAL);
                        p.LCD_write_string(0,4,"Back",MENU_NORMAL);
                    }

                    else if (line == 3) {
                        p.LCD_write_string(25,0,"Admin",MENU_NORMAL);
                        p.LCD_write_string(0,1,"- Motion Graph",MENU_NORMAL);
                        p.LCD_write_string(0,2,"- AC Graph",MENU_NORMAL);
                        p.LCD_write_string(0,3,"- LDR Graph",MENU_HIGHLIGHT);       //line = 2
                        p.LCD_write_string(0,4,"Back",MENU_NORMAL);
                    }

                    else if (line == 4) {
                        p.LCD_write_string(25,0,"Admin",MENU_NORMAL);
                        p.LCD_write_string(0,1,"- Motion Graph",MENU_NORMAL);
                        p.LCD_write_string(0,2,"- AC Graph",MENU_NORMAL);
                        p.LCD_write_string(0,3,"- LDR Graph",MENU_NORMAL);
                        p.LCD_write_string(0,4,"Back",MENU_HIGHLIGHT);              //line = 3
                    }
                }

                else if (select == 0) {                                         // channel selecting button (down)
                    if (line < 4) {
                        //printf("line = %d\n",line);
                        line = line + 1;
                        wait_ms(250);
                    } else line = 0;
                }

                else if (press == 0) {                                          // press button
                    //printf("i am in\n");
                    //printf("line = %d\n",line);

                    if(line == 0) {
                        state = 1;
                        line = 0;
                        break;
                    } else if(line == 1) {
                        state = 10;
                        break;
                    } else if(line == 2) {
                        state = 11;
                        break;
                    } else if(line == 3) {
                        state = 12;
                        break;
                    } else {
                        p.LCD_clear();
                        state = 0;
                        line = 0;
                        break;
                    }
                }

            }
        }

        else if (state == 10) {                                                //Admin Page - Motion Graph
            p.LCD_clear();
            p.LCD_write_string(7,0,"Motion Graph",MENU_HIGHLIGHT);
            p.LCD_draw_bmp_pixel(14,1, img, 70,40);
            wait_ms(250);

            while(1) {
                press = analog_button_press.read();

                if (press == 0) {
                    printf("press\n");
                    p.LCD_clear();
                    state = 1;
                    line = 0;
                    break;
                }
            }
        }

        else if (state == 11) {                                                 //Admin Page - Air Conditioner Graph
            p.LCD_clear();
            p.LCD_write_string(20,0,"AC Graph",MENU_HIGHLIGHT);
            p.LCD_draw_bmp_pixel(14,1, img, 70,40);
            wait_ms(250);

            while(1) {
                press = analog_button_press.read();

                if (press == 0) {
                    printf("press\n");
                    p.LCD_clear();
                    state = 1;
                    line = 0;
                    break;
                }
            }
        }

        else if (state == 12) {                                                 //Admin Page - LDR Graph
            p.LCD_clear();
            p.LCD_write_string(17,0,"LDR Graph",MENU_HIGHLIGHT);
            p.LCD_draw_bmp_pixel(14,1, img, 70,40);
            wait_ms(250);

            while(1) {
                press = analog_button_press.read();

                if (press == 0) {
                    printf("press\n");
                    p.LCD_clear();
                    state = 1;
                    line = 0;
                    break;
                }
            }
        }

        else if (state == 2) {
            p.LCD_clear();
            while(1) {
                p.backlight(0);
                wait_ms(500);
                p.backlight(1);
                wait_ms(500);
                p.LCD_write_string(25,1,"PEASE",MENU_NORMAL);
                p.LCD_write_string(10,3,"TAP ID CARD",MENU_NORMAL);
                wait_ms(250);
                rfid_ID = ReadRFID_forLCD();
                /*
                if (rfid_ID == 1) {                                             // If user tap the card, get out of the loop
                    printf("User detected");
                    p.LCD_clear();
                    state = 0;
                }
                */
            }
        }

    }
}


int ReadRFID_forLCD()
{
    int data[10], card;
    float ss;
    pc.printf("starting...\n");

    // Init. RC522 Chip
    RfChip.PCD_Init();

    while (1) {

        // Look for new cards
        if(data[0] == 199 && data[1] == 230 &&data[2] == 46 &&data[3] == 0 ) {
            //pc.printf(" admin \n");
            data[0] = 0;
            data[1] = 0;
            data[2] = 0;
            data[3] = 0;
            card = 0;
            return card;
        }
        if ( ! RfChip.PICC_IsNewCardPresent()) {
            wait_ms(500);
            continue;
        }

        // Select one of the cards
        if ( ! RfChip.PICC_ReadCardSerial()) {
            wait_ms(500);
            continue;
        }

        // Print Card UID
        pc.printf("Card UID: ");
        for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            data[i] =  RfChip.uid.uidByte[i];
            pc.printf("%d ", data[i]);

        }
        pc.printf("\n\r");
    }
}
