
#include "mbed.h"
#include "LCD_DISCO_F746NG.h"
#include "TS_DISCO_F746NG.h"
#include "F746_GUI.hpp"
#include "DHT.h"


LCD_DISCO_F746NG lcd;
DHT sensor(D3,AM2302);
Serial GPS(A4, A5);
Serial pc (USBTX,USBRX) ;
Serial uCam (D1,D0);



Button GPSDATA(50, 100, 100, 100, "GPS",Font12,LCD_COLOR_BLUE,LCD_COLOR_BLACK,LCD_COLOR_WHITE);
Button TEMPDATA(195, 100, 100, 100, "TEMPERATURE",Font12,LCD_COLOR_BLUE,LCD_COLOR_BLACK,LCD_COLOR_WHITE);
Button CAMERA(340, 100, 100, 100,"CAMERA",Font12,LCD_COLOR_BLUE,LCD_COLOR_BLACK,LCD_COLOR_WHITE);
Button BACK(0, 242, 100, 30,"BACK",Font12,LCD_COLOR_BLUE,LCD_COLOR_BLACK,LCD_COLOR_WHITE);
const unsigned char SYNC[] = {0xAA, 0x0D, 0x00, 0x00, 0x00, 0x00};
const unsigned char ACK[] = {0xAA, 0x0E, 0x0D, 0x00, 0x00, 0x00};
 unsigned char buf[6] = {0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
int err;
int temps = 0;
float Longitude = 0.0, Latitude = 0.0, Altitude = 0.0;
int mode=0;
float heure;
float latitude;
char indic_lat[5];
float longitude;
char indic_long[5];
float vitesse;
float route;
float date;
char heureS[50] = {};
char lat[50] = {};
char i_lat[3] = {};
char lon[50] = {};
char i_lon[3] = {};
char vit[50] = {};
char rou[50] = {};
char dat[50] = {};



int main()
{  
    
    GPS.baud(9600);
    pc.baud(115200);
    char buffer[200];
    int compte=0;
    int resultat;
    //EventQueue queue;
    
    while(1)
    {
        if(CAMERA.Touched())
        {
            GPSDATA.Erase();
            GPSDATA.Inactivate();
            TEMPDATA.Erase();
            TEMPDATA.Inactivate();
            CAMERA.Erase();
            CAMERA.Inactivate();
            lcd.Clear(LCD_COLOR_BLACK);
            mode =1;
            BACK.Activate();
        }
        if(GPSDATA.Touched())
        {
           GPSDATA.Erase();
            GPSDATA.Inactivate();
            TEMPDATA.Erase();
            TEMPDATA.Inactivate();
            CAMERA.Erase();
            CAMERA.Inactivate();
            lcd.Clear(LCD_COLOR_BLACK);
            mode =2;
            BACK.Activate(); 
        }
        if(TEMPDATA.Touched())
        {
            GPSDATA.Erase();
            GPSDATA.Inactivate();
            TEMPDATA.Erase();
            TEMPDATA.Inactivate();
            CAMERA.Erase();
            CAMERA.Inactivate();
            lcd.Clear(LCD_COLOR_BLACK);
            mode=3;
            BACK.Activate();
        }   
        if(BACK.Touched())
        {
            lcd.Clear(LCD_COLOR_BLACK);
            CAMERA.Activate();
            TEMPDATA.Activate();
            GPSDATA.Activate();
            BACK.Activate();
            mode =0;
        }
        switch (mode){
            case 1 :
                // Set uCam baud rate - this is the highest that uCam will auto detect
                    uCam.baud(57600);
                 
                    // Start by Initializing communcation to uCam
                    pc.printf("\n\r-- uCam Initailse --");
                 
                    // This will give 60 attempts to sync with the uCam module
                    for (int i=0; i<=60; i ++) 
                    {
                        // Send out the sync command
                        pc.printf("\n\rSending out SYNC command");
                        for (int i=0; i<6; i++) {
                            uCam.putc(SYNC[i]);
                        }
                 
                        // Get response from uCam
                        if (uCam.readable()) {
                            for (int i=0; i<6; i++) {
                                buf[i] = uCam.getc();
                            }
                        }
                 
                        // Check if it was an ACK
                        if (buf[0] == 0xAA && buf[1] == 0x0E && buf[2] == 0x0D && buf[4] == 0x00 && buf[5] == 0x00) 
                        {
                            pc.printf("\n\rACK received");
                            // Get response from uCam
                            if (uCam.readable()) 
                            {
                                for (int i=0; i<6; i++) 
                                {
                                    buf[i] = uCam.getc();
                                }
                            }
                            if (buf[0] == 0xAA && buf[1] == 0x0D && buf[2] == 0x00 && buf[3] == 0x00 && buf[4] == 0x00 && buf[5] == 0x00) 
                            {
                                pc.printf("\n\rSYNC received");
                                // Send out an ACK as response
                                pc.printf("\n\rSending out ACK command");
                                for (int i=0; i<6; i++) 
                                {
                                    uCam.putc(ACK[i]);
                                }
                                pc.printf("\n\rSYNC complete after %d attempts",i+1);
                                break;
                            } 
                            else 
                            {
                                pc.printf("\n\rNo SYNC received - trying again...");
                            }
                        } 
                        else
                        {
                            pc.printf("\n\rNo ACK received - trying again...");
                        }
                        if (i == 60)
                            pc.printf("\nTesting failed - Too many attempts");
                    }
                    pc.printf("\n\n\rTest finished!");
                break;
            case 2 :
                    
                
                     while (GPS.readable()){
                        
                        buffer[compte]=GPS.getc();                   
                        compte++;
                        if (buffer[compte-1]=='\n')
                        {
                            buffer[compte]='\0';
                            lcd.DisplayStringAt(0, LINE(2), (uint8_t *)buffer, CENTER_MODE);
                            
                            //pc.printf("%s",buffer);
                            
                            sscanf(buffer,"$GPRMC,%f,%f,%c,%f,%c,%f,%f,%f",&heure,&latitude,indic_lat,&longitude,indic_long,&vitesse,&route,&date);
                            //pc.printf("Heure : %s\r\n",heure);
                            sprintf(heureS, "heure : %f  ",heure);
                            sprintf(dat, "date : %f  ",date);
                            lcd.DisplayStringAt(0, LINE(4), (uint8_t *) heureS, CENTER_MODE);
                             lcd.DisplayStringAt(0, LINE(11), (uint8_t *) dat, CENTER_MODE);
                            /*sprintf(lat, "latitude : %.2f  ",latitude);
                            sprintf(i_lat, "%c",indic_lat);
                            sprintf(lon, "longitude : %.2f  ",longitude);
                            sprintf(i_lon, "%c",indic_long);
                            sprintf(vit, "vitesse : %.2f ",vitesse);
                            sprintf(rou, "route : %.2f  ",route);
                            sprintf(dat, "date : %.2f  ",date);
                            
                            lcd.DisplayStringAt(0, LINE(4), (uint8_t *) heureS, CENTER_MODE);
                            lcd.DisplayStringAt(0, LINE(5), (uint8_t *) lat, CENTER_MODE);
                            lcd.DisplayStringAt(0, LINE(6), (uint8_t *) i_lat, CENTER_MODE);
                            lcd.DisplayStringAt(0, LINE(7), (uint8_t *) lon, CENTER_MODE);
                            lcd.DisplayStringAt(0, LINE(8), (uint8_t *) i_lon, CENTER_MODE);
                            lcd.DisplayStringAt(0, LINE(9), (uint8_t *) vit, CENTER_MODE);
                            lcd.DisplayStringAt(0, LINE(10), (uint8_t *) rou, CENTER_MODE);
                           
                            /*pc.printf("Latitude : %f\r\n",latitude);
                            pc.printf("Indic lat : %s\r\n",indic_lat);
                            pc.printf("Longitude : %f\r\n",longitude);
                            pc.printf("Indic_long : %s\r\n",indic_long);
                            pc.printf("Vitesse : %f\r\n",vitesse);
                            pc.printf("Route : %f\r\n",route);
                            pc.printf("Date : %f\r\n",date);*/
                            compte=0;
                            
                        }
                        
                }
                break;
            case 3 :
                lcd.SetTextColor(LCD_COLOR_WHITE);
                lcd.DisplayStringAt(0, LINE(1), (uint8_t *)"DHT program", CENTER_MODE);
                lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"******************", CENTER_MODE);
                wait(1); // wait 1 second for device stable status
                err = sensor.readData();
    
                if (err == 0) 
                
                {
                    char temp[50] = {};
                    char tempF[50] = {};
                    char tempK[50] = {};
                    char humi[50] = {};
                    sprintf(temp, "Temperature is %.2f C ", sensor.ReadTemperature(CELCIUS));
                    sprintf(tempF, "Temperature is %.2f F ", sensor.ReadTemperature(FARENHEIT));
                    sprintf(tempK, "Temperature is %.2f K ", sensor.ReadTemperature(KELVIN));
                    sprintf(humi, "Humidity is %4.1f %% ", sensor.ReadHumidity());
                    lcd.DisplayStringAt(0, LINE(4), (uint8_t *) temp, CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(6), (uint8_t *) tempF, CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(8), (uint8_t *) tempK, CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(10), (uint8_t *) humi, CENTER_MODE);
                    /*lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT), CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"\r\n******************\r\n", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"\r\n******************\r\n", CENTER_MODE);
                    lcd.DisplayStringAt(0, LINE(2), (uint8_t *)"\r\n******************\r\n", CENTER_MODE);
                    printf();
                    printf();
                    printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
                    printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
                    printf("Dew point is %4.2f  \r\n",sensor.CalcdewPoint(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));
                    printf("Dew point (fast) is %4.2f  \r\n",sensor.CalcdewPointFast(sensor.ReadTemperature(CELCIUS), sensor.ReadHumidity()));*/
                } else {
                    //printf("\r\nErr %i \n",err);
                    char prep[50] = {};
                    sprintf(prep, "\r\n Err %i \n", err);
                    //lcd.DisplayStringAt(0, LINE(10), (uint8_t *) prep, CENTER_MODE);
                }
            }
    
        
            
    }
}
