#include "mbed.h"
#include "Thread.h"

// For FRDM board K64F
#if defined TARGET_K64F
#define button_pressed 0
#define led_on 0
#define led_off 1
#define USERBUTTON SW2
#define RED_LED LED1
#define BLUE_LED LED2
#define GREEN_LED LED3
#endif

// For NUCLEO-F429ZI
#if defined TARGET_STM32F429ZI
#define button_pressed 1
#define led_on 1
#define led_off 0
#define USERBUTTON USER_BUTTON
#define RED_LED LED3
#define BLUE_LED LED2
#define GREEN_LED LED1
#endif

DigitalOut red_led(RED_LED, led_off); // RED
DigitalOut green_led(GREEN_LED, led_off); // GREEN
DigitalOut blue_led(BLUE_LED, led_off); // BLUE
DigitalIn button(USERBUTTON);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)

// Connect to serial USB
Serial pc(USBTX, USBRX, 115200);

void led_thread() {
    uint16_t color = 0;
    while (true) {
        color++;
        color = color & 0x7;
        red_led = color & 0x1;
        green_led = color & 0x2;
        pc.printf("Color is: %d\r\n", color);
        Thread::wait(1000);
    }
}


int main() {
    //Create a thread to execute the function led_thread
    Thread::Thread thread1;
    thread1.start(&led_thread);
    uint8_t b_reg = 0;
        
    // Main thread
    while (true) {
        if (button_pressed == button) {
           b_reg = b_reg << 1;
           b_reg |= 1;
           if ((b_reg & 0x17) == 0x17) {
              blue_led = led_on;
              pc.putc('*');
            } else {
                pc.putc('-');
            }
        }
        else {
           b_reg = 0;
           blue_led = led_off;
        }
        Thread::wait(100);
        
    }
}

