/*

EOL SEQUENCE = NONE ON YAT, PROTOCOL WILL FAIL IF THIS IS NOT DONE

*/


#include "mbed.h"
#include <string> 
#include "MotorControl.h"
#include "readCommands.h"
#include "writeCommands.h"
#include "main.h"

//================================================================================================================================
// COMPANY                :  Verderflex
//
// PROJECT                :  ED Motor Controler API
// DATE                   :  11th May 2020   

string HARDWARE =           "Hardware Version : X1.00";                                                
string SOFTWARE =           "Software Version : X1.00";
string AUTHOR   =           "Author : Jim Lowe";

/*
 *   Firmware Numbering Scheme, V Major.Minor.Bugfix
 *
 *   Major  : Major Changes to function
 *   Minor  : Minor Changes to function
 *   Bugfix : Firmware fixes to function
 *
 */

// HARDWARE              :   NUCLEO-F746ZG + Nextion 4.3" Display
//
// COMPILER              :   Mbed Studio

//================================================================================================================================
//************************************************  Code Status / Changes ********************************************************
//================================================================================================================================


/*

    ED Motor Controller API
    
    
    Notes:
    A robust protocal has been called for, the motor command sent out is to be echoed back with and <ACK> or <NACK>
       
    In order to compare what was sent to what is echoed back two buffers are required, a TX buffer and an RX buffer, they can then be compared 
    using memcmp() function
    
    19/03/20    Compare of tx and rx buffers can be done
    20/03/20    Migrate code to mbed studio
    20/03/20    Code cannot be migrated to mbed studio as the target does not use mbed OS 5
    23/03/20    memcmp() and memcpy() implemented and working, comparision of tx and rx buffers can be done
    26/03/20    setSpeed(),setTorque(),setRotMotor(),set_mL() write commands tested and working with echo compare
    26/03/20_D  ACK and NAK added, rx message checked for <CR><ACK> or <NAK>
    27/03/20_D  Sorting of received massages into register type, echo type and NAK seems to be working
    30/03/20_B  Process Motor Message function created that combines all message types that can be transmitted and received
    31/03/20_D  LED1=1 indication validates data automatically, if data is invalid LED1=0 
    03/04/20_A  Setup another serial port required for testing API, one for Debug and the other to communicate with Sagittarius drive
    07/04/20_A  Simplified so that RX ISR collects the data and stores in the required memory location
    08/04/20_B  Software manual IMD11 V00R02 changes need to be added to software, this is a lot of work as we now have to collect a lot of bytes returnd from the motor controller
    11/05/20_A  Back to work,
*/
//What is sent is received exactly, no problems

RawSerial mc_debug(USBTX, USBRX, MED_BAUD);//debug port PA2_TX, PA15_RX
RawSerial mc_usart(PA_9,PA_10,MED_BAUD);//motor controller communication port
//RawSerial mc_debug(PA_2,PB_4,MED_BAUD);//motor controller communication port

//RawSerial mc_debug(PA_9,PA_10,MED_BAUD);//motor controller communication port
//RawSerial mc_usart(USBTX, USBRX, MED_BAUD);//debug port PA2_TX, PA15_RX

Timer tBtn;

DigitalOut led1(LED1);

Timer t1;

uint8_t msgResend = false;

float n_speed = 0.001;

uint8_t cmdCnt=0;
bool rxMsgPending = false;

uint32_t speed=0;

int main(){//1

    Init();
       
    //setup motor control
    a7_out1 = 1;//motor hardware enable
    setTorque(3456, mc_Tx_Buffer);//set torque 3.456N.m  
    setRotMotor(CCW, mc_Tx_Buffer);//set motor CCW rotation
    n_speed = 123.456;
    setSpeed(&n_speed, mc_Tx_Buffer);
    
    tBtn.start();
    
    t1.start();
    
    while(1){//2
    
        /*identify the last message sent    
        
          the mc_Tx_Buffer contain the last message sent out which has failed
          this message need to be resent a number of times (3 tries)
        
        */

        if(tBtn.read() > 0.100){//every x read the buttons
            
            tBtn.reset();
            
            if(d3_button){//speed inc
                if(t1.read() > 1.0){
                    t1.reset();
                    n_speed+=10;

                }
                n_speed+=0.001;
                setSpeed(&n_speed, mc_Tx_Buffer);
            }
            else
            if(d4_button){//speed dec
                if(t1.read() > 1.0){
                    t1.reset();
                    n_speed-=10;
                }
                n_speed-=0.001;
                setSpeed(&n_speed, mc_Tx_Buffer);
            }
            else
            if(d5_button){//stop
               stopMot(STOP_NO_RAMP, NOT_USED,  mc_Tx_Buffer); 
            }
            else
            if(d6_button){
                
            
            }
            else
            if(d7_button){
                
            
            }
            else
            if(d3_button){
                
            
            }
            else
            if(d8_button){
                
            
            }
            else
            if(d9_button){
                
            
            }
            else
            if(d10_button){
                
            
            }
            else
            if(d11_button){
                
            
            }
            else   
            if(d12_button){
                
            
            }
            else
                t1.reset();
        }

        //mc_debug.printf("cmdCnt = %d", cmdCnt);
/*           
        switch(cmdCnt){    
            case 0: setRotMotor(CCW, mc_Tx_Buffer);break;//free run the motor CCW 
            case 1: setSpeed(123456, mc_Tx_Buffer);break;//123.456 RPM  
            case 2: setRotMotor(CW, mc_Tx_Buffer);break;//free run the motor CW
            case 3: setTorque(3456, mc_Tx_Buffer);break;//3.456N.m 
            case 4: setTorque(7000, mc_Tx_Buffer);break;//7N.m    
            case 5: set_mL(CW, 1000, mc_Tx_Buffer);break;//dispence 1000ml running CW
            case 6: set_mL(CCW, 1000, mc_Tx_Buffer);break;//dispence 1000ml running CW
        }
*/        
/*           
        switch(cmdCnt){
            case READ_DIG_IN:               readDigInput(mc_Tx_Buffer);break;
            case READ_DIG_OUT:              readDigOutput(mc_Tx_Buffer);break;
            case READ_CURRENT:              readCurrent(mc_Tx_Buffer);break;
            case READ_DRV_REG:              readDrvReg(mc_Tx_Buffer);break;
            case READ_DRV_REG_EXT:          readDrvRegExt(mc_Tx_Buffer);break;
            case READ_DRV_TEMP:             readTemp(mc_Tx_Buffer);break;
            case READ_DRV_VOLTAGE:          readVoltage(mc_Tx_Buffer);break;
            case READ_DRV_WORKING_SET:      readDrvWorkSet(mc_Tx_Buffer);break;
            case READ_DRV_WORKING_SET_EXT:  readDrvWorkSetExt(mc_Tx_Buffer);break; 
            case READ_ERROR_REG:            readErrReg(mc_Tx_Buffer);break;
            case READ_FB_BOOST_CUR:         readFBboostCur(mc_Tx_Buffer);break;
            case READ_FB_STATUS:            readFBstat(mc_Tx_Buffer);break;
            case READ_FW_VERSION:           readFWVwersion(mc_Tx_Buffer);break;
            case READ_FW_CHECKSUM:          readFWChecksum(mc_Tx_Buffer);break;
            case READ_MASTER_REG:           readMastReg(mc_Tx_Buffer);break;   
            case READ_MIN_CURRENT:          readMinCur(mc_Tx_Buffer);break;
            case READ_MAX_CURRENT:          readMaxCur(mc_Tx_Buffer);break;
            case READ_BOOST_CURRENT:        readBoostCur(mc_Tx_Buffer);break;  
            case READ_NOM_CURRENT:          readNomCur(mc_Tx_Buffer);break;                
        }
*/        
 /*
         if(rxMsgPending == false){   
            rxMsgPending = true;
            
             if(cmdCnt < COMMANDS_TO_TEST) 
                cmdCnt++;
            else
                cmdCnt=0;     
        }
*/        

        //while(getMotMsg(mc_Tx_Buffer, rxMsgStore) == RX_ECHO_FAIL);//message has failed so resent the last message again and loop a nuber of re-tries if required.
    
        
        if(getMotMsg(mc_Tx_Buffer, rxMsgStore) == REBOOT){
            mc_usart.printf("\r\n\r\nRebooting the system\r\n\r\n");  
            NVIC_SystemReset(); 
        }
        
        
    }//2     
}//1