#ifndef MOTORCONTROL_H
#define MOTORCONTROL_H

#include "mbed.h"
#include <string> 

#define DEBUG


#define ED_MIN_SPEED            1000
#define ED_MAX_SPEED            3000000
#define N_MIN_SPEED             0.001
#define N_MAX_SPEED             125.000//125.0RPM

#define REV_MAX_STEPS           -2147483648
#define FWD_MAX_STEPS           2147483648

#define MIN_CURRENT             0
#define MAX_CURRENT             6000//6000mA

#define MIN_TORQUE              0
#define MAX_TORQUE              8500//N.m


#define SPACE                   0x20 
#define ACK                     0x06
#define NAK                     0x15

#define VALID_MSG_LEN           0x03

#define ML_ROTATION             5.6
#define STEPS_PER_ROTATION      1024

#define CW                      1
#define CCW                     0

#define RX_ECHO_VALID           0 
#define RX_ECHO_FAIL            1
#define RX_REGITSER_FAIL        2
#define RX_REGITSER_VALID       3
#define MSG_RESEND              4

#define REBOOT                  5

#define MSG_RETRY_COUNT         3
 
#define NOT_USED                0 
#define STOP_NO_RAMP            0
#define STOP_WITH_RAMP          1 
#define STOP_WITH_STEPS         2

#define BUFFER_SIZE             50//command message + data
#define DATA_BUFFER_SIZE        20//characters
#define DATA_ITEMS              19

////////////////////////////////////////////
// MOTOR COMMAND RESPONSE DATA STORAGE 
/////////////////////////////////////////// 
#define READ_DIG_IN                 0
#define READ_DIG_OUT                1
#define READ_CURRENT                2
#define READ_DRV_REG                3
#define READ_DRV_REG_EXT            4
#define READ_DRV_TEMP               5
#define READ_DRV_VOLTAGE            6
#define READ_DRV_WORKING_SET        7
#define READ_DRV_WORKING_SET_EXT    8
#define READ_ERROR_REG              9 
#define READ_FB_BOOST_CUR           10
#define READ_FB_STATUS              11
#define READ_FW_VERSION             12
#define READ_FW_CHECKSUM            13
#define READ_MASTER_REG             14
#define READ_MIN_CURRENT            15
#define READ_MAX_CURRENT            16
#define READ_BOOST_CURRENT          17
#define READ_NOM_CURRENT            18

#define COMMANDS_TO_TEST            10


////////////////////////////////////////////
// BAUD RATES
///////////////////////////////////////////
#define SLOW_BAUD               9600
#define MED_BAUD                115200
#define FAST_BAUD               921600
 
#define MOT_AL_PDT              0x0001//Protection Drive Thermal
#define MOT_AL_PDV              0x0002//Protection Drive Voltage
#define MOT_AL_PDC              0x0004//Protection Drive Current
#define MOT_AL_POP              0x0008//Protection Open Phase
#define MOT_AL_UNUSED1          0x0010//NOT USED
#define MOT_AL_FE               0x0020//Feedback Error    
#define MOT_AL_PCR              0x0040//Protection Current Regulation
#define MOT_AL_POT              0x0080//Protection Open Transistor
#define MOT_AL_UNUSED2          0x0100//NOT USED
#define MOT_AL_SWER             0x0200//Protection Software Error
#define MOT_AL_UNUSED3          0x0400//NOT USED
#define MOT_AL_MC               0x0800//Missing Calibration
#define MOT_AL_WDG              0x1000//Watchdog
#define MOT_AL_EEF              0x2000//EEPROM Fail
#define MOT_AL_I2T              0x4000//I2T Potection
#define MOT_AL_UNUSED4          0x8000//NOT USED

 
#define D3_BUTTON               D3
#define D4_BUTTON               D4
#define D5_BUTTON               D5
#define D6_BUTTON               D6
#define D7_BUTTON               D7
#define D8_BUTTON               D8
#define D9_BUTTON               D9
#define D10_BUTTON              D10
#define D11_BUTTON              D11
#define D12_BUTTON              D12

#define A7_OUT1                 A7
#define A6_OUT2                 A6
#define A5_OUT3                 A5

#define A4_IN1                  A4
#define A3_IN2                  A3
#define A2_IN3                  A2

#define A1_OUT                  A1
#define A0_OUT                  A0

extern DigitalIn d3_button;
extern DigitalIn d4_button;
extern DigitalIn d5_button;
extern DigitalIn d6_button;
extern DigitalIn d7_button;
extern DigitalIn d8_button;
extern DigitalIn d9_button;
extern DigitalIn d10_button;
extern DigitalIn d11_button;
extern DigitalIn d12_button;

extern DigitalOut a7_out1;
extern DigitalOut a6_out2;
extern DigitalOut a5_out3;
extern DigitalIn a4_in1;
extern DigitalIn a3_in2;
extern DigitalIn a2_in3;

extern DigitalOut a1_out;
extern DigitalOut a0_out;

extern char motData[][DATA_BUFFER_SIZE];//data only

extern char binBuffer[];
extern uint8_t cnt;
extern const string rxMsgTable[];
extern char rxMsgStore[];//received local message store
extern char mc_Tx_Buffer[];//transmitted message buffer 
extern char mc_Rx_Buffer[];//received message buffer
extern volatile unsigned char mc_Rx_Rd_Ptr;//circulare buffer read pointer
extern volatile unsigned char mc_Rx_Wr_Ptr;//circulare buffer write pointer
extern unsigned int rx_int;//received integer / character
extern volatile bool rxMsgValid;//message received flag
extern bool msgRdy;

void motEncoderISR(void);

void int2bin(int value, char* buffer, int bufferSize);

void rstPointers(void);

void readCurrent(char *array);
bool setDigOutput(uint8_t par1, char *array);
void readDigInput(char *array);
void clrRxMsg(char *array);
void motMsg_RX_ISR(void);
uint8_t getMotMsg(char *txReadCmd, char *rxRegArray);




bool set_mL(bool direction, uint32_t mL, char *array);
bool setRotMotor(bool direction, char *array);

void initBuffer(string s, char *array, char character, uint8_t size);

void dispBuffer(string s, uint8_t size, char array[]);
void dispMotReg(string s, uint8_t regSel, char regArray[9][BUFFER_SIZE]);


uint8_t procMotMsg(char *txMsg, char *rxMsg, char motReg[9][BUFFER_SIZE]);
void dispRegDec(string s, uint8_t regSel, char regArray[9][BUFFER_SIZE]);
void dispRegHex(string s, uint8_t regSel, char regArray[9][BUFFER_SIZE]);


void data2mem(uint8_t dataLoc, char destMemArray[][DATA_BUFFER_SIZE], char sourceMemArray[BUFFER_SIZE]);//for command with <CR><VALUE>  
void Init(void);

long mapI(long x, long in_min, long in_max, long out_min, long out_max);
float mapF(float in, float inMin, float inMax, float outMin, float outMax);

#endif