/* NextionLCD Library v1.0
 * Copyright (c) 2018 Grant Phillips
 * grant.phillips@mandela.ac.za
 *
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
#ifndef NEXTIONLCD_H
#define NEXTIONLCD_H
 
#include "mbed.h"

#define BLACK   0
#define BLUE    31
#define BROWN   48192
#define GREEN   1024
#define YELLOW  65504
#define RED     63488
#define GRAY    33840
#define WHITE   65535
 
//extern NextionLCD lcd;//Tx, Rx, Nextion Port

extern bool push;
extern bool pop;
extern volatile bool keyScanFlag;
extern bool scrnUpdate;//Update the Nexion screen

extern uint8_t nexDataLSB;
extern uint8_t nexDataMSB;
extern volatile uint8_t page;
extern volatile uint8_t id;
extern volatile bool pushPop;

class NextionLCD 
{
  public:

    NextionLCD(PinName Tx, PinName Rx);
    void nexRst(void);
    void nexSendVal(string id,uint16_t val);
    void nexSetBckLite(uint8_t val);//ok        
    void nexCls(string colour);
    void nexSetBaud(uint32_t baud);//ok                  
    void nexChgPage(uint8_t page);//ok             
    void nexSetDSBtn(string id, uint8_t on_off);    
    void nexRotArrow(bool on_off);
    void nexSetCrop(string id, uint16_t picc);//ok    
    void nexSetTimer(string id,uint16_t tim, uint16_t on_off);//ok        
    void nexSetSlider(string id, uint16_t sliderVal);//ok        
    void nexSetPrgBar(string id, uint16_t progBarVal);//ok    
    void nexSendTxt(string id,string txt);//ok
    void ClrScr(uint16_t color);//ok
    void nexSendGetVal(string id);    
    void nexSetFont(string id, uint8_t val);
    void nexSendFloat(string id,float val,uint8_t p);
    void nexLoadSD(void);
    void nexDrawLine(uint16_t x1, uint16_t y1, uint16_t x2, uint16_t y2, uint16_t color);
    void nexSetFontCol(string id, uint16_t colour);
    void nexDispSymbol(string id, bool on_off);
        
    
  private:
    RawSerial lcd;             //Serial object for connecting to Nextion LCD
    //Serial pc;
    bool mTouch;
    int mTouchX, mTouchY;
    char mRxMsg[40];
    int mRxIdx;
    void RxInterrupt(void); //Rx Interrupt
};
 
#endif
